/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ParallelDynamicStitch", inputsClass=Inputs.class)
public final class ParallelDynamicStitch<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ParallelDynamicStitch";
    private Output<T> merged;

    public ParallelDynamicStitch(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.merged = operation.output(outputIdx++);
    }

    public static <T extends TType> ParallelDynamicStitch<T> create(Scope scope, Iterable<Operand<TInt32>> indices, Iterable<Operand<T>> data) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(indices));
        opBuilder.addInputList(Operands.asOutputs(data));
        return new ParallelDynamicStitch<T>(opBuilder.build());
    }

    public Output<T> merged() {
        return this.merged;
    }

    @Override
    public Output<T> asOutput() {
        return this.merged;
    }

    @OpInputsMetadata(outputsClass=ParallelDynamicStitch.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<ParallelDynamicStitch<T>> {
        public final Iterable<Operand<TInt32>> indices;
        public final Iterable<Operand<T>> data;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new ParallelDynamicStitch(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            int indicesLength = op.inputListLength("indices");
            this.indices = Arrays.asList((Operand[])op.inputList(inputIndex, indicesLength));
            int dataLength = op.inputListLength("data");
            this.data = Arrays.asList((Operand[])op.inputList(inputIndex += indicesLength, dataLength));
            inputIndex += dataLength;
            this.T = op.attributes().getAttrType("T");
        }
    }
}

