/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RegisterDataset", inputsClass=Inputs.class)
public final class RegisterDataset
extends RawOp
implements Operand<TInt64> {
    public static final String OP_NAME = "RegisterDataset";
    private Output<TInt64> datasetId;

    public RegisterDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.datasetId = operation.output(outputIdx++);
    }

    public static RegisterDataset create(Scope scope, Operand<? extends TType> dataset, Operand<TString> address, Operand<TString> protocol, Long externalStatePolicy, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(dataset.asOutput());
        opBuilder.addInput(address.asOutput());
        opBuilder.addInput(protocol.asOutput());
        opBuilder.setAttr("external_state_policy", externalStatePolicy);
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementSpec == null) continue;
                opBuilder.setAttr("element_spec", opts.elementSpec);
            }
        }
        return new RegisterDataset(opBuilder.build());
    }

    public static Options elementSpec(String elementSpec) {
        return new Options().elementSpec(elementSpec);
    }

    public Output<TInt64> datasetId() {
        return this.datasetId;
    }

    @Override
    public Output<TInt64> asOutput() {
        return this.datasetId;
    }

    @OpInputsMetadata(outputsClass=RegisterDataset.class)
    public static class Inputs
    extends RawOpInputs<RegisterDataset> {
        public final Operand<? extends TType> dataset;
        public final Operand<TString> address;
        public final Operand<TString> protocol;
        public final long externalStatePolicy;
        public final String elementSpec;

        public Inputs(GraphOperation op) {
            super(new RegisterDataset(op), op, Arrays.asList("external_state_policy", "element_spec"));
            int inputIndex = 0;
            this.dataset = op.input(inputIndex++);
            this.address = op.input(inputIndex++);
            this.protocol = op.input(inputIndex++);
            this.externalStatePolicy = op.attributes().getAttrInt("external_state_policy");
            this.elementSpec = op.attributes().getAttrString("element_spec");
        }
    }

    public static class Options {
        private String elementSpec;

        private Options() {
        }

        public Options elementSpec(String elementSpec) {
            this.elementSpec = elementSpec;
            return this;
        }
    }
}

