/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DecodeCSV", inputsClass=Inputs.class)
public final class DecodeCsv
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "DecodeCSV";
    private List<Output<?>> output;

    public DecodeCsv(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static DecodeCsv create(Scope scope, Operand<TString> records, Iterable<Operand<?>> recordDefaults, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DecodeCsv");
        opBuilder.addInput(records.asOutput());
        opBuilder.addInputList(Operands.asOutputs(recordDefaults));
        if (options != null) {
            for (Options opts : options) {
                if (opts.fieldDelim != null) {
                    opBuilder.setAttr("field_delim", opts.fieldDelim);
                }
                if (opts.useQuoteDelim != null) {
                    opBuilder.setAttr("use_quote_delim", opts.useQuoteDelim);
                }
                if (opts.naValue != null) {
                    opBuilder.setAttr("na_value", opts.naValue);
                }
                if (opts.selectCols == null) continue;
                long[] selectColsArray = new long[opts.selectCols.size()];
                for (int i = 0; i < selectColsArray.length; ++i) {
                    selectColsArray[i] = (Long)opts.selectCols.get(i);
                }
                opBuilder.setAttr("select_cols", selectColsArray);
            }
        }
        return new DecodeCsv(opBuilder.build());
    }

    public static Options fieldDelim(String fieldDelim) {
        return new Options().fieldDelim(fieldDelim);
    }

    public static Options useQuoteDelim(Boolean useQuoteDelim) {
        return new Options().useQuoteDelim(useQuoteDelim);
    }

    public static Options naValue(String naValue) {
        return new Options().naValue(naValue);
    }

    public static Options selectCols(List<Long> selectCols) {
        return new Options().selectCols(selectCols);
    }

    public static Options selectCols(Long ... selectCols) {
        return new Options().selectCols(selectCols);
    }

    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=DecodeCsv.class)
    public static class Inputs
    extends RawOpInputs<DecodeCsv> {
        public final Operand<TString> records;
        public final Iterable<Operand<?>> recordDefaults;
        public final DataType[] OUTTYPE;
        public final String fieldDelim;
        public final boolean useQuoteDelim;
        public final String naValue;
        public final long[] selectCols;

        public Inputs(GraphOperation op) {
            super(new DecodeCsv(op), op, Arrays.asList("OUT_TYPE", "field_delim", "use_quote_delim", "na_value", "select_cols"));
            int inputIndex = 0;
            this.records = op.input(inputIndex++);
            int recordDefaultsLength = op.inputListLength("record_defaults");
            this.recordDefaults = Arrays.asList((Operand[])op.inputList(inputIndex, recordDefaultsLength));
            inputIndex += recordDefaultsLength;
            this.OUTTYPE = op.attributes().getAttrTypeList("OUT_TYPE");
            this.fieldDelim = op.attributes().getAttrString("field_delim");
            this.useQuoteDelim = op.attributes().getAttrBool("use_quote_delim");
            this.naValue = op.attributes().getAttrString("na_value");
            this.selectCols = op.attributes().getAttrIntList("select_cols");
        }
    }

    public static class Options {
        private String fieldDelim;
        private Boolean useQuoteDelim;
        private String naValue;
        private List<Long> selectCols;

        private Options() {
        }

        public Options fieldDelim(String fieldDelim) {
            this.fieldDelim = fieldDelim;
            return this;
        }

        public Options useQuoteDelim(Boolean useQuoteDelim) {
            this.useQuoteDelim = useQuoteDelim;
            return this;
        }

        public Options naValue(String naValue) {
            this.naValue = naValue;
            return this;
        }

        public Options selectCols(List<Long> selectCols) {
            this.selectCols = selectCols;
            return this;
        }

        public Options selectCols(Long ... selectCols) {
            this.selectCols = Arrays.asList(selectCols);
            return this;
        }
    }
}

