/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bytedeco.javacpp.Loader;
import org.tensorflow.TensorFlow;
import org.tensorflow.internal.c_api.global.tensorflow;

final class NativeLibrary {
    private static final boolean DEBUG = System.getProperty("org.tensorflow.NativeLibrary.DEBUG") != null;
    private static final String JNI_LIBNAME = "tensorflow_jni";

    public static void load() {
        Loader.load(tensorflow.class);
        if (NativeLibrary.isLoaded() || NativeLibrary.tryLoadLibrary()) {
            return;
        }
        String jniLibName = System.mapLibraryName(JNI_LIBNAME);
        String jniResourceName = NativeLibrary.makeResourceName(jniLibName);
        NativeLibrary.log("jniResourceName: " + jniResourceName);
        InputStream jniResource = NativeLibrary.class.getClassLoader().getResourceAsStream(jniResourceName);
        String frameworkLibName = NativeLibrary.getVersionedLibraryName(System.mapLibraryName("tensorflow_framework"));
        String frameworkResourceName = NativeLibrary.makeResourceName(frameworkLibName);
        NativeLibrary.log("frameworkResourceName: " + frameworkResourceName);
        InputStream frameworkResource = NativeLibrary.class.getClassLoader().getResourceAsStream(frameworkResourceName);
        if (jniResource == null) {
            throw new UnsatisfiedLinkError(String.format("Cannot find TensorFlow native library for OS: %s, architecture: %s. See https://github.com/tensorflow/tensorflow/tree/master/tensorflow/java/README.md for possible solutions (such as building the library from source). Additional information on attempts to find the native library can be obtained by adding org.tensorflow.NativeLibrary.DEBUG=1 to the system properties of the JVM.", NativeLibrary.os(), NativeLibrary.architecture()));
        }
        try {
            File tempPath = NativeLibrary.createTemporaryDirectory();
            tempPath.deleteOnExit();
            String tempDirectory = tempPath.getCanonicalPath();
            if (frameworkResource != null) {
                NativeLibrary.extractResource(frameworkResource, frameworkLibName, tempDirectory);
            } else {
                NativeLibrary.log(frameworkResourceName + " not found. This is fine assuming " + jniResourceName + " is not built to depend on it.");
            }
            System.load(NativeLibrary.extractResource(jniResource, jniLibName, tempDirectory));
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(String.format("Unable to extract native library into a temporary file (%s)", e.toString()));
        }
    }

    private static boolean tryLoadLibrary() {
        try {
            System.loadLibrary(JNI_LIBNAME);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            NativeLibrary.log("tryLoadLibraryFailed: " + e.getMessage());
            return false;
        }
    }

    private static boolean isLoaded() {
        try {
            TensorFlow.version();
            NativeLibrary.log("isLoaded: true");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    private static boolean resourceExists(String baseName) {
        return NativeLibrary.class.getClassLoader().getResource(NativeLibrary.makeResourceName(baseName)) != null;
    }

    private static String getVersionedLibraryName(String libFilename) {
        if (NativeLibrary.resourceExists(libFilename)) {
            return libFilename;
        }
        String versionName = NativeLibrary.getMajorVersionNumber();
        String darwinSuffix = ".dylib";
        if (libFilename.endsWith(".dylib")) {
            String prefix = libFilename.substring(0, libFilename.length() - ".dylib".length());
            if (versionName != null) {
                String darwinVersionedLibrary = prefix + "." + versionName + ".dylib";
                if (NativeLibrary.resourceExists(darwinVersionedLibrary)) {
                    return darwinVersionedLibrary;
                }
            } else {
                String darwinSoName = prefix + ".so";
                if (NativeLibrary.resourceExists(darwinSoName)) {
                    return darwinSoName;
                }
            }
        } else if (libFilename.endsWith(".so")) {
            String versionedSoName = libFilename + "." + versionName;
            if (versionName != null && NativeLibrary.resourceExists(versionedSoName)) {
                return versionedSoName;
            }
        }
        return libFilename;
    }

    private static String getMajorVersionNumber() {
        int dotIndex;
        String version = NativeLibrary.class.getPackage().getImplementationVersion();
        if (version == null || (dotIndex = version.indexOf(46)) == -1) {
            return null;
        }
        String majorVersion = version.substring(0, dotIndex);
        try {
            Integer.parseInt(majorVersion);
            return majorVersion;
        }
        catch (NumberFormatException unused) {
            return null;
        }
    }

    private static String extractResource(InputStream resource, String resourceName, String extractToDirectory) throws IOException {
        File dst = new File(extractToDirectory, resourceName);
        dst.deleteOnExit();
        String dstPath = dst.toString();
        NativeLibrary.log("extracting native library to: " + dstPath);
        long nbytes = NativeLibrary.copy(resource, dst);
        NativeLibrary.log(String.format("copied %d bytes to %s", nbytes, dstPath));
        return dstPath;
    }

    private static String os() {
        String p = System.getProperty("os.name").toLowerCase();
        if (p.contains("linux")) {
            return "linux";
        }
        if (p.contains("os x") || p.contains("darwin")) {
            return "darwin";
        }
        if (p.contains("windows")) {
            return "windows";
        }
        return p.replaceAll("\\s", "");
    }

    private static String architecture() {
        String arch = System.getProperty("os.arch").toLowerCase();
        return arch.equals("amd64") ? "x86_64" : arch;
    }

    private static void log(String msg) {
        if (DEBUG) {
            System.err.println("org.tensorflow.NativeLibrary: " + msg);
        }
    }

    private static String makeResourceName(String baseName) {
        return "org/tensorflow/native/" + String.format("%s-%s/", NativeLibrary.os(), NativeLibrary.architecture()) + baseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream src, File dstFile) throws IOException {
        FileOutputStream dst = new FileOutputStream(dstFile);
        try {
            byte[] buffer = new byte[0x100000];
            long ret = 0L;
            int n = 0;
            while ((n = src.read(buffer)) >= 0) {
                dst.write(buffer, 0, n);
                ret += (long)n;
            }
            long l = ret;
            return l;
        }
        finally {
            dst.close();
            src.close();
        }
    }

    private static File createTemporaryDirectory() {
        File baseDirectory = new File(System.getProperty("java.io.tmpdir"));
        String directoryName = "tensorflow_native_libraries-" + System.currentTimeMillis() + "-";
        for (int attempt = 0; attempt < 1000; ++attempt) {
            File temporaryDirectory = new File(baseDirectory, directoryName + attempt);
            if (!temporaryDirectory.mkdir()) continue;
            return temporaryDirectory;
        }
        throw new IllegalStateException("Could not create a temporary directory (tried to make " + directoryName + "*) to extract TensorFlow native libraries.");
    }

    private NativeLibrary() {
    }
}

