/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayouts;
import org.tensorflow.ndarray.impl.dense.FloatDenseNdArray;
import org.tensorflow.types.TFloat16;

public final class TFloat16Mapper
extends TensorMapper<TFloat16> {
    @Override
    protected TFloat16 mapDense(RawTensor tensor) {
        DataBuffer buffer = DataLayouts.FLOAT16.applyTo((DataBuffer)TensorBuffers.toShorts(TFloat16Mapper.nativeHandle(tensor)));
        return new DenseTFloat16(tensor, (FloatDataBuffer)buffer);
    }

    private static final class DenseTFloat16
    extends FloatDenseNdArray
    implements TFloat16 {
        final RawTensor rawTensor;

        public Class<TFloat16> type() {
            return TFloat16.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTFloat16(RawTensor rawTensor, FloatDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

