/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.nio;

import java.nio.ShortBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.nio.AbstractNioDataBuffer;

final class ShortNioDataBuffer
extends AbstractNioDataBuffer<Short>
implements ShortDataBuffer {
    private ShortBuffer buf;

    @Override
    public short getShort(long index) {
        return this.buf.get((int)index);
    }

    @Override
    public ShortDataBuffer setShort(short value, long index) {
        this.buf.put((int)index, value);
        return this;
    }

    @Override
    public ShortDataBuffer read(short[] dst, int offset, int length) {
        this.buf.duplicate().get(dst, offset, length);
        return this;
    }

    @Override
    public ShortDataBuffer write(short[] src, int offset, int length) {
        this.buf.duplicate().put(src, offset, length);
        return this;
    }

    @Override
    public ShortDataBuffer copyTo(final DataBuffer<Short> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<ShortDataBuffer>(){

            @Override
            public ShortDataBuffer visit(ShortBuffer buffer) {
                buffer.duplicate().put((ShortBuffer)ShortNioDataBuffer.this.buf.duplicate().limit((int)size));
                return ShortNioDataBuffer.this;
            }

            @Override
            public ShortDataBuffer fallback() {
                if (dst instanceof ShortDataBuffer) {
                    ShortDataBuffer shortDst = (ShortDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        shortDst.setShort(ShortNioDataBuffer.this.getShort(idx), idx);
                    }
                    return ShortNioDataBuffer.this;
                }
                return (ShortDataBuffer)ShortNioDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public ShortDataBuffer offset(long index) {
        Validator.offsetArgs(this, index);
        return new ShortNioDataBuffer(((ShortBuffer)this.buf.duplicate().position((int)index)).slice());
    }

    @Override
    public ShortDataBuffer narrow(long size) {
        Validator.narrowArgs(this, size);
        return new ShortNioDataBuffer(((ShortBuffer)this.buf.duplicate().limit((int)size)).slice());
    }

    @Override
    public ShortDataBuffer slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        ShortBuffer sliceBuf = this.buf.duplicate();
        sliceBuf.position((int)index);
        sliceBuf.limit((int)index + (int)size);
        return new ShortNioDataBuffer(sliceBuf.slice());
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.buf);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortDataBuffer)) {
            return super.equals(obj);
        }
        final ShortDataBuffer other = (ShortDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(ShortBuffer buffer) {
                return ShortNioDataBuffer.this.buf.equals(buffer);
            }

            @Override
            public Boolean fallback() {
                int idx = 0;
                while ((long)idx < ShortNioDataBuffer.this.size()) {
                    if (other.getShort(idx) != ShortNioDataBuffer.this.getShort(idx)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        });
    }

    @Override
    ShortBuffer buf() {
        return this.buf;
    }

    ShortNioDataBuffer(ShortBuffer buf) {
        this.buf = buf;
    }
}

