/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.strings.Join;
import org.tensorflow.op.strings.Lower;
import org.tensorflow.op.strings.ReduceJoin;
import org.tensorflow.op.strings.RegexFullMatch;
import org.tensorflow.op.strings.RegexReplace;
import org.tensorflow.op.strings.StringFormat;
import org.tensorflow.op.strings.StringLength;
import org.tensorflow.op.strings.StringNGrams;
import org.tensorflow.op.strings.StringSplit;
import org.tensorflow.op.strings.Strip;
import org.tensorflow.op.strings.Substr;
import org.tensorflow.op.strings.ToHashBucket;
import org.tensorflow.op.strings.ToHashBucketFast;
import org.tensorflow.op.strings.ToHashBucketStrong;
import org.tensorflow.op.strings.ToNumber;
import org.tensorflow.op.strings.UnicodeScript;
import org.tensorflow.op.strings.UnicodeTranscode;
import org.tensorflow.op.strings.UnsortedSegmentJoin;
import org.tensorflow.op.strings.Upper;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

public final class StringsOps {
    private final Scope scope;
    private final Ops ops;

    StringsOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public Join join(Iterable<Operand<TString>> inputs, Join.Options ... options) {
        return Join.create(this.scope, inputs, options);
    }

    public Lower lower(Operand<TString> input, Lower.Options ... options) {
        return Lower.create(this.scope, input, options);
    }

    public ReduceJoin reduceJoin(Operand<TString> inputs, Operand<TInt32> reductionIndices, ReduceJoin.Options ... options) {
        return ReduceJoin.create(this.scope, inputs, reductionIndices, options);
    }

    public RegexFullMatch regexFullMatch(Operand<TString> input, Operand<TString> pattern) {
        return RegexFullMatch.create(this.scope, input, pattern);
    }

    public RegexReplace regexReplace(Operand<TString> input, Operand<TString> pattern, Operand<TString> rewrite, RegexReplace.Options ... options) {
        return RegexReplace.create(this.scope, input, pattern, rewrite, options);
    }

    public StringFormat stringFormat(Iterable<Operand<?>> inputs, StringFormat.Options ... options) {
        return StringFormat.create(this.scope, inputs, options);
    }

    public StringLength stringLength(Operand<TString> input, StringLength.Options ... options) {
        return StringLength.create(this.scope, input, options);
    }

    public <T extends TNumber> StringNGrams<T> stringNGrams(Operand<TString> data, Operand<T> dataSplits, String separator, List<Long> ngramWidths, String leftPad, String rightPad, Long padWidth, Boolean preserveShortSequences) {
        return StringNGrams.create(this.scope, data, dataSplits, separator, ngramWidths, leftPad, rightPad, padWidth, preserveShortSequences);
    }

    public StringSplit stringSplit(Operand<TString> input, Operand<TString> sep, StringSplit.Options ... options) {
        return StringSplit.create(this.scope, input, sep, options);
    }

    public Strip strip(Operand<TString> input) {
        return Strip.create(this.scope, input);
    }

    public <T extends TNumber> Substr substr(Operand<TString> input, Operand<T> pos, Operand<T> len, Substr.Options ... options) {
        return Substr.create(this.scope, input, pos, len, options);
    }

    public ToHashBucket toHashBucket(Operand<TString> stringTensor, Long numBuckets) {
        return ToHashBucket.create(this.scope, stringTensor, numBuckets);
    }

    public ToHashBucketFast toHashBucketFast(Operand<TString> input, Long numBuckets) {
        return ToHashBucketFast.create(this.scope, input, numBuckets);
    }

    public ToHashBucketStrong toHashBucketStrong(Operand<TString> input, Long numBuckets, List<Long> key) {
        return ToHashBucketStrong.create(this.scope, input, numBuckets, key);
    }

    public ToNumber<TFloat32> toNumber(Operand<TString> stringTensor) {
        return ToNumber.create(this.scope, stringTensor);
    }

    public <T extends TNumber> ToNumber<T> toNumber(Operand<TString> stringTensor, Class<T> outType) {
        return ToNumber.create(this.scope, stringTensor, outType);
    }

    public UnicodeScript unicodeScript(Operand<TInt32> input) {
        return UnicodeScript.create(this.scope, input);
    }

    public UnicodeTranscode unicodeTranscode(Operand<TString> input, String inputEncoding, String outputEncoding, UnicodeTranscode.Options ... options) {
        return UnicodeTranscode.create(this.scope, input, inputEncoding, outputEncoding, options);
    }

    public UnsortedSegmentJoin unsortedSegmentJoin(Operand<TString> inputs, Operand<? extends TNumber> segmentIds, Operand<? extends TNumber> numSegments, UnsortedSegmentJoin.Options ... options) {
        return UnsortedSegmentJoin.create(this.scope, inputs, segmentIds, numSegments, options);
    }

    public Upper upper(Operand<TString> input, Upper.Options ... options) {
        return Upper.create(this.scope, input, options);
    }

    public final Ops ops() {
        return this.ops;
    }
}

