/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MutableDenseHashTableV2", inputsClass=Inputs.class)
public final class MutableDenseHashTable
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "MutableDenseHashTableV2";
    private Output<? extends TType> tableHandle;

    public MutableDenseHashTable(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.tableHandle = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TType> MutableDenseHashTable create(Scope scope, Operand<T> emptyKey, Operand<T> deletedKey, Class<U> valueDtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "MutableDenseHashTable");
        opBuilder.addInput(emptyKey.asOutput());
        opBuilder.addInput(deletedKey.asOutput());
        opBuilder.setAttr("value_dtype", Operands.toDataType(valueDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.useNodeNameSharing != null) {
                    opBuilder.setAttr("use_node_name_sharing", opts.useNodeNameSharing);
                }
                if (opts.valueShape != null) {
                    opBuilder.setAttr("value_shape", opts.valueShape);
                }
                if (opts.initialNumBuckets != null) {
                    opBuilder.setAttr("initial_num_buckets", opts.initialNumBuckets);
                }
                if (opts.maxLoadFactor == null) continue;
                opBuilder.setAttr("max_load_factor", opts.maxLoadFactor.floatValue());
            }
        }
        return new MutableDenseHashTable(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options useNodeNameSharing(Boolean useNodeNameSharing) {
        return new Options().useNodeNameSharing(useNodeNameSharing);
    }

    public static Options valueShape(Shape valueShape) {
        return new Options().valueShape(valueShape);
    }

    public static Options initialNumBuckets(Long initialNumBuckets) {
        return new Options().initialNumBuckets(initialNumBuckets);
    }

    public static Options maxLoadFactor(Float maxLoadFactor) {
        return new Options().maxLoadFactor(maxLoadFactor);
    }

    public Output<? extends TType> tableHandle() {
        return this.tableHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.tableHandle;
    }

    @OpInputsMetadata(outputsClass=MutableDenseHashTable.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<MutableDenseHashTable> {
        public final Operand<T> emptyKey;
        public final Operand<T> deletedKey;
        public final String container;
        public final String sharedName;
        public final boolean useNodeNameSharing;
        public final DataType keyDtype;
        public final DataType valueDtype;
        public final Shape valueShape;
        public final long initialNumBuckets;
        public final float maxLoadFactor;

        public Inputs(GraphOperation op) {
            super(new MutableDenseHashTable(op), op, Arrays.asList("container", "shared_name", "use_node_name_sharing", "key_dtype", "value_dtype", "value_shape", "initial_num_buckets", "max_load_factor"));
            int inputIndex = 0;
            this.emptyKey = op.input(inputIndex++);
            this.deletedKey = op.input(inputIndex++);
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.useNodeNameSharing = op.attributes().getAttrBool("use_node_name_sharing");
            this.keyDtype = op.attributes().getAttrType("key_dtype");
            this.valueDtype = op.attributes().getAttrType("value_dtype");
            this.valueShape = op.attributes().getAttrShape("value_shape");
            this.initialNumBuckets = op.attributes().getAttrInt("initial_num_buckets");
            this.maxLoadFactor = op.attributes().getAttrFloat("max_load_factor");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;
        private Boolean useNodeNameSharing;
        private Shape valueShape;
        private Long initialNumBuckets;
        private Float maxLoadFactor;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options useNodeNameSharing(Boolean useNodeNameSharing) {
            this.useNodeNameSharing = useNodeNameSharing;
            return this;
        }

        public Options valueShape(Shape valueShape) {
            this.valueShape = valueShape;
            return this;
        }

        public Options initialNumBuckets(Long initialNumBuckets) {
            this.initialNumBuckets = initialNumBuckets;
            return this;
        }

        public Options maxLoadFactor(Float maxLoadFactor) {
            this.maxLoadFactor = maxLoadFactor;
            return this;
        }
    }
}

