/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ShardDataset", inputsClass=Inputs.class)
public final class ShardDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ShardDataset";
    private Output<? extends TType> handle;

    public ShardDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static ShardDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> numShards, Operand<TInt64> index, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numShards.asOutput());
        opBuilder.addInput(index.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.requireNonEmpty != null) {
                    opBuilder.setAttr("require_non_empty", opts.requireNonEmpty);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new ShardDataset(opBuilder.build());
    }

    public static Options requireNonEmpty(Boolean requireNonEmpty) {
        return new Options().requireNonEmpty(requireNonEmpty);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=ShardDataset.class)
    public static class Inputs
    extends RawOpInputs<ShardDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> numShards;
        public final Operand<TInt64> index;
        public final boolean requireNonEmpty;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new ShardDataset(op), op, Arrays.asList("require_non_empty", "output_types", "output_shapes", "metadata"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.numShards = op.input(inputIndex++);
            this.index = op.input(inputIndex++);
            this.requireNonEmpty = op.attributes().getAttrBool("require_non_empty");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private Boolean requireNonEmpty;
        private String metadata;

        private Options() {
        }

        public Options requireNonEmpty(Boolean requireNonEmpty) {
            this.requireNonEmpty = requireNonEmpty;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

