/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="BoostedTreesSparseAggregateStats", inputsClass=Inputs.class)
public final class BoostedTreesSparseAggregateStats
extends RawOp {
    public static final String OP_NAME = "BoostedTreesSparseAggregateStats";
    private Output<TInt32> statsSummaryIndices;
    private Output<TFloat32> statsSummaryValues;
    private Output<TInt32> statsSummaryShape;

    public BoostedTreesSparseAggregateStats(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.statsSummaryIndices = operation.output(outputIdx++);
        this.statsSummaryValues = operation.output(outputIdx++);
        this.statsSummaryShape = operation.output(outputIdx++);
    }

    public static BoostedTreesSparseAggregateStats create(Scope scope, Operand<TInt32> nodeIds, Operand<TFloat32> gradients, Operand<TFloat32> hessians, Operand<TInt32> featureIndices, Operand<TInt32> featureValues, Operand<TInt32> featureShape, Long maxSplits, Long numBuckets) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(nodeIds.asOutput());
        opBuilder.addInput(gradients.asOutput());
        opBuilder.addInput(hessians.asOutput());
        opBuilder.addInput(featureIndices.asOutput());
        opBuilder.addInput(featureValues.asOutput());
        opBuilder.addInput(featureShape.asOutput());
        opBuilder.setAttr("max_splits", maxSplits);
        opBuilder.setAttr("num_buckets", numBuckets);
        return new BoostedTreesSparseAggregateStats(opBuilder.build());
    }

    public Output<TInt32> statsSummaryIndices() {
        return this.statsSummaryIndices;
    }

    public Output<TFloat32> statsSummaryValues() {
        return this.statsSummaryValues;
    }

    public Output<TInt32> statsSummaryShape() {
        return this.statsSummaryShape;
    }

    @OpInputsMetadata(outputsClass=BoostedTreesSparseAggregateStats.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesSparseAggregateStats> {
        public final Operand<TInt32> nodeIds;
        public final Operand<TFloat32> gradients;
        public final Operand<TFloat32> hessians;
        public final Operand<TInt32> featureIndices;
        public final Operand<TInt32> featureValues;
        public final Operand<TInt32> featureShape;
        public final long maxSplits;
        public final long numBuckets;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesSparseAggregateStats(op), op, Arrays.asList("max_splits", "num_buckets"));
            int inputIndex = 0;
            this.nodeIds = op.input(inputIndex++);
            this.gradients = op.input(inputIndex++);
            this.hessians = op.input(inputIndex++);
            this.featureIndices = op.input(inputIndex++);
            this.featureValues = op.input(inputIndex++);
            this.featureShape = op.input(inputIndex++);
            this.maxSplits = op.attributes().getAttrInt("max_splits");
            this.numBuckets = op.attributes().getAttrInt("num_buckets");
        }
    }
}

