/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="QuantizedConcat", inputsClass=Inputs.class)
public final class QuantizedConcat<T extends TType>
extends RawOp {
    public static final String OP_NAME = "QuantizedConcat";
    private Output<T> output;
    private Output<TFloat32> outputMin;
    private Output<TFloat32> outputMax;

    public QuantizedConcat(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }

    public static <T extends TType> QuantizedConcat<T> create(Scope scope, Operand<TInt32> concatDim, Iterable<Operand<T>> values, Iterable<Operand<TFloat32>> inputMins, Iterable<Operand<TFloat32>> inputMaxes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(concatDim.asOutput());
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(inputMins));
        opBuilder.addInputList(Operands.asOutputs(inputMaxes));
        return new QuantizedConcat<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<TFloat32> outputMin() {
        return this.outputMin;
    }

    public Output<TFloat32> outputMax() {
        return this.outputMax;
    }

    @OpInputsMetadata(outputsClass=QuantizedConcat.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<QuantizedConcat<T>> {
        public final Operand<TInt32> concatDim;
        public final Iterable<Operand<T>> values;
        public final Iterable<Operand<TFloat32>> inputMins;
        public final Iterable<Operand<TFloat32>> inputMaxes;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new QuantizedConcat(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.concatDim = op.input(inputIndex++);
            int valuesLength = op.inputListLength("values");
            this.values = Arrays.asList((Operand[])op.inputList(inputIndex, valuesLength));
            int inputMinsLength = op.inputListLength("input_mins");
            this.inputMins = Arrays.asList((Operand[])op.inputList(inputIndex += valuesLength, inputMinsLength));
            int inputMaxesLength = op.inputListLength("input_maxes");
            this.inputMaxes = Arrays.asList((Operand[])op.inputList(inputIndex += inputMinsLength, inputMaxesLength));
            inputIndex += inputMaxesLength;
            this.T = op.attributes().getAttrType("T");
        }
    }
}

