/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UnicodeEncode", inputsClass=Inputs.class)
public final class UnicodeEncode
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "UnicodeEncode";
    private Output<TString> output;

    public UnicodeEncode(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static UnicodeEncode create(Scope scope, Operand<TInt32> inputValues, Operand<? extends TNumber> inputSplits, String outputEncoding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputValues.asOutput());
        opBuilder.addInput(inputSplits.asOutput());
        opBuilder.setAttr("output_encoding", outputEncoding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.errors != null) {
                    opBuilder.setAttr("errors", opts.errors);
                }
                if (opts.replacementChar == null) continue;
                opBuilder.setAttr("replacement_char", opts.replacementChar);
            }
        }
        return new UnicodeEncode(opBuilder.build());
    }

    public static Options errors(String errors) {
        return new Options().errors(errors);
    }

    public static Options replacementChar(Long replacementChar) {
        return new Options().replacementChar(replacementChar);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UnicodeEncode.class)
    public static class Inputs
    extends RawOpInputs<UnicodeEncode> {
        public final Operand<TInt32> inputValues;
        public final Operand<? extends TNumber> inputSplits;
        public final String errors;
        public final String outputEncoding;
        public final long replacementChar;
        public final DataType Tsplits;

        public Inputs(GraphOperation op) {
            super(new UnicodeEncode(op), op, Arrays.asList("errors", "output_encoding", "replacement_char", "Tsplits"));
            int inputIndex = 0;
            this.inputValues = op.input(inputIndex++);
            this.inputSplits = op.input(inputIndex++);
            this.errors = op.attributes().getAttrString("errors");
            this.outputEncoding = op.attributes().getAttrString("output_encoding");
            this.replacementChar = op.attributes().getAttrInt("replacement_char");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
        }
    }

    public static class Options {
        private String errors;
        private Long replacementChar;

        private Options() {
        }

        public Options errors(String errors) {
            this.errors = errors;
            return this;
        }

        public Options replacementChar(Long replacementChar) {
            this.replacementChar = replacementChar;
            return this;
        }
    }
}

