/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaBroadcastHelper", inputsClass=Inputs.class)
public final class BroadcastHelper<T extends TType>
extends RawOp {
    public static final String OP_NAME = "XlaBroadcastHelper";
    private Output<T> lhsOutput;
    private Output<T> rhsOutput;

    public BroadcastHelper(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.lhsOutput = operation.output(outputIdx++);
        this.rhsOutput = operation.output(outputIdx++);
    }

    public static <T extends TType> BroadcastHelper<T> create(Scope scope, Operand<T> lhs, Operand<T> rhs, Operand<? extends TNumber> broadcastDims) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "BroadcastHelper");
        opBuilder.addInput(lhs.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder.addInput(broadcastDims.asOutput());
        return new BroadcastHelper<T>(opBuilder.build());
    }

    public Output<T> lhsOutput() {
        return this.lhsOutput;
    }

    public Output<T> rhsOutput() {
        return this.rhsOutput;
    }

    @OpInputsMetadata(outputsClass=BroadcastHelper.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<BroadcastHelper<T>> {
        public final Operand<T> lhs;
        public final Operand<T> rhs;
        public final Operand<? extends TNumber> broadcastDims;
        public final DataType T;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new BroadcastHelper(op), op, Arrays.asList("T", "Tindices"));
            int inputIndex = 0;
            this.lhs = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.broadcastDims = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }
}

