/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaGather", inputsClass=Inputs.class)
public final class Gather<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaGather";
    private Output<T> output;

    public Gather(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TNumber> Gather<T> create(Scope scope, Operand<T> operand, Operand<U> startIndices, Operand<U> sliceSizes, String dimensionNumbers, Boolean indicesAreSorted) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Gather");
        opBuilder.addInput(operand.asOutput());
        opBuilder.addInput(startIndices.asOutput());
        opBuilder.addInput(sliceSizes.asOutput());
        opBuilder.setAttr("dimension_numbers", dimensionNumbers);
        opBuilder.setAttr("indices_are_sorted", indicesAreSorted);
        return new Gather<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Gather.class)
    public static class Inputs<T extends TType, U extends TNumber>
    extends RawOpInputs<Gather<T>> {
        public final Operand<T> operand;
        public final Operand<U> startIndices;
        public final Operand<U> sliceSizes;
        public final String dimensionNumbers;
        public final boolean indicesAreSorted;
        public final DataType T;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new Gather(op), op, Arrays.asList("dimension_numbers", "indices_are_sorted", "T", "Tindices"));
            int inputIndex = 0;
            this.operand = op.input(inputIndex++);
            this.startIndices = op.input(inputIndex++);
            this.sliceSizes = op.input(inputIndex++);
            this.dimensionNumbers = op.attributes().getAttrString("dimension_numbers");
            this.indicesAreSorted = op.attributes().getAttrBool("indices_are_sorted");
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }
}

