/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.layout;

import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.buffer.layout.FloatDataLayout;

public final class Float16Layout
implements FloatDataLayout<ShortDataBuffer> {
    private static final int E32SHIFT = 23;
    private static final int E32MASK = 2139095040;
    private static final int E32BIAS = 127;
    private static final int S32BITS = 23;
    private static final int E16SHIFT = 10;
    private static final int E16MASK = 31744;
    private static final int E16BIAS = 15;
    private static final int E16MAX = 15;
    private static final int E16MIN = -14;
    private static final int S16BITS = 10;
    private static final int MAGIC_32_16 = 0x3F000000;
    private static final float MAGIC_32_16_FLOAT = Float.intBitsToFloat(0x3F000000);
    private static final int MAGIC_16_32 = 0x38800000;
    private static final float MAGIC_16_32_FLOAT = Float.intBitsToFloat(0x38800000);

    @Override
    public void writeFloat(ShortDataBuffer buffer, float value, long index) {
        buffer.setShort(Float16Layout.float32to16(value), index);
    }

    @Override
    public float readFloat(ShortDataBuffer buffer, long index) {
        return Float16Layout.float16to32(buffer.getShort(index));
    }

    static short float32to16(float f32) {
        int i16;
        int i32 = Float.floatToIntBits(f32);
        short sign16 = (short)(i32 >>> 16 & 0x8000);
        if ((i32 &= Integer.MAX_VALUE) >= 1199570944) {
            i16 = i32 > 2139095040 ? 32256 : 31744;
        } else if (i32 < 0x38800000) {
            i16 = Float.floatToIntBits(Float.intBitsToFloat(i32) + MAGIC_32_16_FLOAT) - 0x3F000000;
        } else {
            int round = 4095 + (i32 >>> 13 & 1);
            i16 = i32 + -939524096 + round >>> 13;
        }
        return (short)(i16 | sign16);
    }

    static float float16to32(short i16) {
        int i32 = (i16 & Short.MAX_VALUE) << 13;
        i32 += 0x38000000;
        switch (i16 & 0x7C00) {
            case 31744: {
                i32 += 0x38000000;
                break;
            }
            case 0: {
                i32 = Float.floatToIntBits(Float.intBitsToFloat(i32 + 0x800000) - MAGIC_16_32_FLOAT);
                break;
            }
        }
        return Float.intBitsToFloat(i32 | (i16 & 0x8000) << 16);
    }
}

