/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CollectiveGatherV2", inputsClass=Inputs.class)
public final class CollectiveGather<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CollectiveGatherV2";
    private Output<T> data;

    public CollectiveGather(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.data = operation.output(outputIdx++);
    }

    public static <T extends TNumber> CollectiveGather<T> create(Scope scope, Operand<T> input, Operand<TInt32> groupSize, Operand<TInt32> groupKey, Operand<TInt32> instanceKey, Iterable<Operand<? extends TType>> orderingToken, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CollectiveGather");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(groupSize.asOutput());
        opBuilder.addInput(groupKey.asOutput());
        opBuilder.addInput(instanceKey.asOutput());
        opBuilder.addInputList(Operands.asOutputs(orderingToken));
        if (options != null) {
            for (Options opts : options) {
                if (opts.communicationHint != null) {
                    opBuilder.setAttr("communication_hint", opts.communicationHint);
                }
                if (opts.timeoutSeconds != null) {
                    opBuilder.setAttr("timeout_seconds", opts.timeoutSeconds.floatValue());
                }
                if (opts.NorderingToken == null) continue;
                opBuilder.setAttr("Nordering_token", opts.NorderingToken);
            }
        }
        return new CollectiveGather<T>(opBuilder.build());
    }

    public static Options communicationHint(String communicationHint) {
        return new Options().communicationHint(communicationHint);
    }

    public static Options timeoutSeconds(Float timeoutSeconds) {
        return new Options().timeoutSeconds(timeoutSeconds);
    }

    public static Options NorderingToken(Long NorderingToken) {
        return new Options().NorderingToken(NorderingToken);
    }

    public Output<T> data() {
        return this.data;
    }

    @Override
    public Output<T> asOutput() {
        return this.data;
    }

    @OpInputsMetadata(outputsClass=CollectiveGather.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<CollectiveGather<T>> {
        public final Operand<T> input;
        public final Operand<TInt32> groupSize;
        public final Operand<TInt32> groupKey;
        public final Operand<TInt32> instanceKey;
        public final Iterable<Operand<? extends TType>> orderingToken;
        public final DataType T;
        public final String communicationHint;
        public final float timeoutSeconds;

        public Inputs(GraphOperation op) {
            super(new CollectiveGather(op), op, Arrays.asList("T", "communication_hint", "timeout_seconds"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.groupSize = op.input(inputIndex++);
            this.groupKey = op.input(inputIndex++);
            this.instanceKey = op.input(inputIndex++);
            int orderingTokenLength = op.inputListLength("ordering_token");
            this.orderingToken = Arrays.asList((Operand[])op.inputList(inputIndex, orderingTokenLength));
            inputIndex += orderingTokenLength;
            this.T = op.attributes().getAttrType("T");
            this.communicationHint = op.attributes().getAttrString("communication_hint");
            this.timeoutSeconds = op.attributes().getAttrFloat("timeout_seconds");
        }
    }

    public static class Options {
        private String communicationHint;
        private Float timeoutSeconds;
        private Long NorderingToken;

        private Options() {
        }

        public Options communicationHint(String communicationHint) {
            this.communicationHint = communicationHint;
            return this;
        }

        public Options timeoutSeconds(Float timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Options NorderingToken(Long NorderingToken) {
            this.NorderingToken = NorderingToken;
            return this;
        }
    }
}

