/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Send", inputsClass=Inputs.class)
public final class Send
extends RawOp {
    public static final String OP_NAME = "Send";

    public Send(Operation operation) {
        super(operation, OP_NAME);
    }

    public static Send create(Scope scope, Operand<? extends TType> tensor, String tensorName, String sendDevice, Long sendDeviceIncarnation, String recvDevice, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(tensor.asOutput());
        opBuilder.setAttr("tensor_name", tensorName);
        opBuilder.setAttr("send_device", sendDevice);
        opBuilder.setAttr("send_device_incarnation", sendDeviceIncarnation);
        opBuilder.setAttr("recv_device", recvDevice);
        if (options != null) {
            for (Options opts : options) {
                if (opts.clientTerminated == null) continue;
                opBuilder.setAttr("client_terminated", opts.clientTerminated);
            }
        }
        return new Send(opBuilder.build());
    }

    public static Options clientTerminated(Boolean clientTerminated) {
        return new Options().clientTerminated(clientTerminated);
    }

    @OpInputsMetadata(outputsClass=Send.class)
    public static class Inputs
    extends RawOpInputs<Send> {
        public final Operand<? extends TType> tensor;
        public final DataType T;
        public final String tensorName;
        public final String sendDevice;
        public final long sendDeviceIncarnation;
        public final String recvDevice;
        public final boolean clientTerminated;

        public Inputs(GraphOperation op) {
            super(new Send(op), op, Arrays.asList("T", "tensor_name", "send_device", "send_device_incarnation", "recv_device", "client_terminated"));
            int inputIndex = 0;
            this.tensor = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.tensorName = op.attributes().getAttrString("tensor_name");
            this.sendDevice = op.attributes().getAttrString("send_device");
            this.sendDeviceIncarnation = op.attributes().getAttrInt("send_device_incarnation");
            this.recvDevice = op.attributes().getAttrString("recv_device");
            this.clientTerminated = op.attributes().getAttrBool("client_terminated");
        }
    }

    public static class Options {
        private Boolean clientTerminated;

        private Options() {
        }

        public Options clientTerminated(Boolean clientTerminated) {
            this.clientTerminated = clientTerminated;
            return this;
        }
    }
}

