/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorListConcatLists", inputsClass=Inputs.class)
public final class TensorListConcatLists
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TensorListConcatLists";
    private Output<? extends TType> output;

    public TensorListConcatLists(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> TensorListConcatLists create(Scope scope, Operand<? extends TType> inputA, Operand<? extends TType> inputB, Class<T> elementDtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputA.asOutput());
        opBuilder.addInput(inputB.asOutput());
        opBuilder.setAttr("element_dtype", Operands.toDataType(elementDtype));
        return new TensorListConcatLists(opBuilder.build());
    }

    public Output<? extends TType> output() {
        return this.output;
    }

    @Override
    public Output<TType> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=TensorListConcatLists.class)
    public static class Inputs
    extends RawOpInputs<TensorListConcatLists> {
        public final Operand<? extends TType> inputA;
        public final Operand<? extends TType> inputB;
        public final DataType elementDtype;

        public Inputs(GraphOperation op) {
            super(new TensorListConcatLists(op), op, Arrays.asList("element_dtype"));
            int inputIndex = 0;
            this.inputA = op.input(inputIndex++);
            this.inputB = op.input(inputIndex++);
            this.elementDtype = op.attributes().getAttrType("element_dtype");
        }
    }
}

