/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorListSplit", inputsClass=Inputs.class)
public final class TensorListSplit
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TensorListSplit";
    private Output<? extends TType> outputHandle;

    public TensorListSplit(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputHandle = operation.output(outputIdx++);
    }

    public static TensorListSplit create(Scope scope, Operand<? extends TType> tensor, Operand<? extends TNumber> elementShape, Operand<TInt64> lengths) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(tensor.asOutput());
        opBuilder.addInput(elementShape.asOutput());
        opBuilder.addInput(lengths.asOutput());
        return new TensorListSplit(opBuilder.build());
    }

    public Output<? extends TType> outputHandle() {
        return this.outputHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.outputHandle;
    }

    @OpInputsMetadata(outputsClass=TensorListSplit.class)
    public static class Inputs
    extends RawOpInputs<TensorListSplit> {
        public final Operand<? extends TType> tensor;
        public final Operand<? extends TNumber> elementShape;
        public final Operand<TInt64> lengths;
        public final DataType elementDtype;
        public final DataType shapeType;

        public Inputs(GraphOperation op) {
            super(new TensorListSplit(op), op, Arrays.asList("element_dtype", "shape_type"));
            int inputIndex = 0;
            this.tensor = op.input(inputIndex++);
            this.elementShape = op.input(inputIndex++);
            this.lengths = op.input(inputIndex++);
            this.elementDtype = op.attributes().getAttrType("element_dtype");
            this.shapeType = op.attributes().getAttrType("shape_type");
        }
    }
}

