/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.internal.c_api.GradFunc;
import org.tensorflow.internal.c_api.NativeOutput;
import org.tensorflow.internal.c_api.NativeOutputVector;
import org.tensorflow.internal.c_api.Node;
import org.tensorflow.internal.c_api.TF_Operation;

public abstract class BaseGradientAdapter
extends GradFunc {
    protected BaseGradientAdapter() {
    }

    protected static List<Output<?>> fromNativeOutputs(Graph g, NativeOutputVector nativeOutputs) {
        ArrayList gradInputs = new ArrayList((int)nativeOutputs.size());
        int i = 0;
        while ((long)i < nativeOutputs.size()) {
            NativeOutput output = nativeOutputs.get(i);
            gradInputs.add(new Output(BaseGradientAdapter.getGraphOp(g, output.node()), output.index()));
            ++i;
        }
        return gradInputs;
    }

    protected static void putToNativeOutputs(List<Operand<?>> outputs, NativeOutputVector nativeOutputs) {
        nativeOutputs.resize(outputs.size());
        for (int i = 0; i < outputs.size(); ++i) {
            Output<?> output = outputs.get(i).asOutput();
            Node node = ((GraphOperation)output.op()).getUnsafeNativeHandle().node();
            nativeOutputs.put(i, new NativeOutput(node, output.index()));
        }
    }

    protected static GraphOperation getGraphOp(Graph g, Node node) {
        try (PointerScope scope = new PointerScope();){
            Graph.Reference ref = g.ref();
            try {
                GraphOperation graphOperation = new GraphOperation(g, new TF_Operation(node));
                if (ref != null) {
                    ref.close();
                }
                return graphOperation;
            }
            catch (Throwable throwable) {
                if (ref != null) {
                    try {
                        ref.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    protected static void useDangerousLockedBuilders(Graph g, boolean dangerous) {
        g.setDangerousGradientBuilder(dangerous);
    }
}

