/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.bytedeco.javacpp.Pointer;

public class WeakPointerScope
implements AutoCloseable {
    private Set<Pointer> pointers = Collections.newSetFromMap(new WeakHashMap());

    public void attach(Pointer pointer) {
        this.checkScope();
        if (this.pointers.add(pointer)) {
            pointer.retainReference();
        }
    }

    public void detach(Pointer pointer) {
        this.checkScope();
        if (this.pointers.remove(pointer)) {
            pointer.releaseReference();
        }
    }

    @Override
    public synchronized void close() {
        this.checkScope();
        this.pointers.forEach(Pointer::releaseReference);
        this.pointers = null;
    }

    private void checkScope() {
        if (this.pointers == null) {
            throw new IllegalStateException("Pointer scope has been closed");
        }
    }
}

