/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.impl.dense.FloatDenseNdArray;
import org.tensorflow.ndarray.impl.sparse.FloatSparseNdArray;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;

public final class TFloat32Mapper
extends TensorMapper<TFloat32> {
    @Override
    protected TFloat32 mapDense(RawTensor tensor) {
        FloatDataBuffer buffer = TensorBuffers.toFloats(TFloat32Mapper.nativeHandle(tensor));
        return new DenseTFloat32(tensor, buffer);
    }

    @Override
    protected SparseTensor<TFloat32> mapSparse(TInt64 indices, TFloat32 values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTFloat32(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTFloat32
    extends FloatSparseNdArray
    implements TFloat32,
    SparseTensor<TFloat32> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TFloat32> type() {
            return TFloat32.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TFloat32 values() {
            return (TFloat32)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        SparseTFloat32(TInt64 indices, TFloat32 values, TInt64 denseShape, PointerScope tensorScope) {
            super((LongNdArray)indices, values, 0.0f, SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = tensorScope.extend();
        }
    }

    private static final class DenseTFloat32
    extends FloatDenseNdArray
    implements TFloat32 {
        final RawTensor rawTensor;

        public Class<TFloat32> type() {
            return TFloat32.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTFloat32(RawTensor rawTensor, FloatDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

