/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.misc;

import java.util.Arrays;
import java.util.BitSet;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.impl.buffer.AbstractDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;

class BooleanArrayDataBuffer
extends AbstractDataBuffer<Boolean>
implements BooleanDataBuffer {
    private final boolean[] values;
    private final boolean readOnly;
    private final int offset;
    private final int length;

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean getBoolean(long index) {
        Validator.getArgs(this, index);
        return this.values[(int)index + this.offset];
    }

    @Override
    public BooleanDataBuffer setBoolean(boolean value, long index) {
        Validator.setArgs(this, index);
        this.values[(int)index + this.offset] = value;
        return this;
    }

    @Override
    public BooleanDataBuffer read(boolean[] dst, int offset, int length) {
        System.arraycopy(this.values, this.offset, dst, offset, length);
        return this;
    }

    @Override
    public BooleanDataBuffer write(boolean[] src, int offset, int length) {
        System.arraycopy(src, offset, this.values, this.offset, length);
        return null;
    }

    @Override
    public BooleanDataBuffer copyTo(final DataBuffer<Boolean> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<BooleanDataBuffer>(){

            @Override
            public BooleanDataBuffer visit(boolean[] array, int arrayOffset, int arrayLength) {
                System.arraycopy(BooleanArrayDataBuffer.this.values, BooleanArrayDataBuffer.this.offset, array, arrayOffset, (int)size);
                return BooleanArrayDataBuffer.this;
            }

            @Override
            public BooleanDataBuffer visit(BitSet bitSet, int bitSetOffset, long numBits) {
                int idx = 0;
                while ((long)idx < size) {
                    bitSet.set(idx + bitSetOffset, BooleanArrayDataBuffer.this.values[idx + BooleanArrayDataBuffer.this.offset]);
                    ++idx;
                }
                return BooleanArrayDataBuffer.this;
            }

            @Override
            public BooleanDataBuffer fallback() {
                if (dst instanceof BooleanDataBuffer) {
                    BooleanDataBuffer booleanDst = (BooleanDataBuffer)dst;
                    int idx = 0;
                    while ((long)idx < size) {
                        booleanDst.setBoolean(BooleanArrayDataBuffer.this.values[idx + BooleanArrayDataBuffer.this.offset], idx);
                        ++idx;
                    }
                } else {
                    int idx = 0;
                    while ((long)idx < size) {
                        dst.setObject(BooleanArrayDataBuffer.this.values[idx + BooleanArrayDataBuffer.this.offset], idx);
                        ++idx;
                    }
                }
                return BooleanArrayDataBuffer.this;
            }
        });
    }

    @Override
    public BooleanDataBuffer slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        return new BooleanArrayDataBuffer(this.values, this.readOnly, this.offset + (int)index, (int)size);
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.values, this.offset, this.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanDataBuffer)) {
            return super.equals(obj);
        }
        final BooleanDataBuffer other = (BooleanDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(boolean[] array, int arrayOffset, int arrayLength) {
                if (BooleanArrayDataBuffer.this.offset == 0 && BooleanArrayDataBuffer.this.values.length == BooleanArrayDataBuffer.this.length && arrayOffset == 0 && array.length == arrayLength) {
                    return Arrays.equals(array, BooleanArrayDataBuffer.this.values);
                }
                int idx = 0;
                while ((long)idx < BooleanArrayDataBuffer.this.size()) {
                    if (array[idx + arrayOffset] != BooleanArrayDataBuffer.this.values[idx + BooleanArrayDataBuffer.this.offset]) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }

            @Override
            public Boolean visit(BitSet bitSet, int bitSetOffset, long numBits) {
                int idx = 0;
                while ((long)idx < BooleanArrayDataBuffer.this.size()) {
                    if (bitSet.get(idx + bitSetOffset) != BooleanArrayDataBuffer.this.values[idx + BooleanArrayDataBuffer.this.offset]) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }

            @Override
            public Boolean fallback() {
                int idx = 0;
                while ((long)idx < BooleanArrayDataBuffer.this.size()) {
                    if (other.getBoolean(idx) != BooleanArrayDataBuffer.this.values[idx + BooleanArrayDataBuffer.this.offset]) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        });
    }

    BooleanArrayDataBuffer(boolean[] values, boolean readOnly) {
        this(values, readOnly, 0, values.length);
    }

    private BooleanArrayDataBuffer(boolean[] values, boolean readOnly, int offset, int length) {
        this.values = values;
        this.readOnly = readOnly;
        this.offset = offset;
        this.length = length;
    }
}

