/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.dense;

import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.impl.dense.AbstractDenseNdArray;
import org.tensorflow.ndarray.impl.dense.DataTransfer;
import org.tensorflow.ndarray.impl.dense.Validator;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;

public class DenseNdArray<T>
extends AbstractDenseNdArray<T, NdArray<T>> {
    private final DataBuffer<T> buffer;

    public static <T> NdArray<T> wrap(DataBuffer<T> buffer, Shape shape) {
        Validator.denseShape(buffer, shape);
        return new DenseNdArray<T>(buffer, shape);
    }

    @Override
    public NdArray<T> copyTo(NdArray<T> dst) {
        Validator.copyToNdArrayArgs(this, dst);
        if (dst instanceof DenseNdArray) {
            DenseNdArray denseDst = (DenseNdArray)dst;
            DataTransfer.execute(this.buffer, this.dimensions(), denseDst.buffer, denseDst.dimensions(), DataTransfer::ofValue);
        } else {
            this.slowCopyTo(dst);
        }
        return this;
    }

    protected DenseNdArray(DataBuffer<T> buffer, Shape shape) {
        this(buffer, DimensionalSpace.create(shape));
    }

    @Override
    DenseNdArray<T> instantiate(DataBuffer<T> buffer, DimensionalSpace dimensions) {
        return new DenseNdArray<T>(buffer, dimensions);
    }

    @Override
    protected DataBuffer<T> buffer() {
        return this.buffer;
    }

    private DenseNdArray(DataBuffer<T> buffer, DimensionalSpace dimensions) {
        super(dimensions);
        this.buffer = buffer;
    }
}

