/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExtractImagePatches", inputsClass=Inputs.class)
public final class ExtractImagePatches<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ExtractImagePatches";
    private Output<T> patches;

    public ExtractImagePatches(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.patches = operation.output(outputIdx++);
    }

    public static <T extends TType> ExtractImagePatches<T> create(Scope scope, Operand<T> images, List<Long> ksizes, List<Long> strides, List<Long> rates, String padding) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(images.asOutput());
        long[] ksizesArray = new long[ksizes.size()];
        for (int i = 0; i < ksizesArray.length; ++i) {
            ksizesArray[i] = ksizes.get(i);
        }
        opBuilder.setAttr("ksizes", ksizesArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        long[] ratesArray = new long[rates.size()];
        for (int i = 0; i < ratesArray.length; ++i) {
            ratesArray[i] = rates.get(i);
        }
        opBuilder.setAttr("rates", ratesArray);
        opBuilder.setAttr("padding", padding);
        return new ExtractImagePatches<T>(opBuilder.build());
    }

    public Output<T> patches() {
        return this.patches;
    }

    @Override
    public Output<T> asOutput() {
        return this.patches;
    }

    @OpInputsMetadata(outputsClass=ExtractImagePatches.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<ExtractImagePatches<T>> {
        public final Operand<T> images;
        public final long[] ksizes;
        public final long[] strides;
        public final long[] rates;
        public final DataType T;
        public final String padding;

        public Inputs(GraphOperation op) {
            super(new ExtractImagePatches(op), op, Arrays.asList("ksizes", "strides", "rates", "T", "padding"));
            int inputIndex = 0;
            this.images = op.input(inputIndex++);
            this.ksizes = op.attributes().getAttrIntList("ksizes");
            this.strides = op.attributes().getAttrIntList("strides");
            this.rates = op.attributes().getAttrIntList("rates");
            this.T = op.attributes().getAttrType("T");
            this.padding = op.attributes().getAttrString("padding");
        }
    }
}

