/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUPartitionedCall", inputsClass=Inputs.class)
public final class PartitionedCall
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "TPUPartitionedCall";
    private List<Output<?>> output;

    public PartitionedCall(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static PartitionedCall create(Scope scope, Iterable<Operand<?>> args, Operand<TInt32> deviceOrdinal, List<Class<? extends TType>> Tout, ConcreteFunction f, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "PartitionedCall");
        opBuilder.addInputList(Operands.asOutputs(args));
        opBuilder.addInput(deviceOrdinal.asOutput());
        opBuilder.setAttr("Tout", Operands.toDataTypes(Tout));
        opBuilder.setAttr("f", f);
        if (options != null) {
            for (Options opts : options) {
                if (opts.autotunerThresh == null) continue;
                opBuilder.setAttr("autotuner_thresh", opts.autotunerThresh);
            }
        }
        return new PartitionedCall(opBuilder.build());
    }

    public static Options autotunerThresh(Long autotunerThresh) {
        return new Options().autotunerThresh(autotunerThresh);
    }

    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=PartitionedCall.class)
    public static class Inputs
    extends RawOpInputs<PartitionedCall> {
        public final Iterable<Operand<?>> args;
        public final Operand<TInt32> deviceOrdinal;
        public final DataType[] Tin;
        public final DataType[] Tout;
        public final long autotunerThresh;

        public Inputs(GraphOperation op) {
            super(new PartitionedCall(op), op, Arrays.asList("Tin", "Tout", "autotuner_thresh"));
            int inputIndex = 0;
            int argsLength = op.inputListLength("args");
            this.args = Arrays.asList((Operand[])op.inputList(inputIndex, argsLength));
            inputIndex += argsLength;
            this.deviceOrdinal = op.input(inputIndex++);
            this.Tin = op.attributes().getAttrTypeList("Tin");
            this.Tout = op.attributes().getAttrTypeList("Tout");
            this.autotunerThresh = op.attributes().getAttrInt("autotuner_thresh");
        }
    }

    public static class Options {
        private Long autotunerThresh;

        private Options() {
        }

        public Options autotunerThresh(Long autotunerThresh) {
            this.autotunerThresh = autotunerThresh;
            return this;
        }
    }
}

