/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BatchMatMulV3", inputsClass=Inputs.class)
public final class BatchMatMul<V extends TType>
extends RawOp
implements Operand<V> {
    public static final String OP_NAME = "BatchMatMulV3";
    private Output<V> output;

    public BatchMatMul(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <V extends TType> BatchMatMul<V> create(Scope scope, Operand<? extends TType> x, Operand<? extends TType> y, Class<V> Tout, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "BatchMatMul");
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(y.asOutput());
        opBuilder.setAttr("Tout", Operands.toDataType(Tout));
        if (options != null) {
            for (Options opts : options) {
                if (opts.adjX != null) {
                    opBuilder.setAttr("adj_x", opts.adjX);
                }
                if (opts.adjY == null) continue;
                opBuilder.setAttr("adj_y", opts.adjY);
            }
        }
        return new BatchMatMul<V>(opBuilder.build());
    }

    public static Options adjX(Boolean adjX) {
        return new Options().adjX(adjX);
    }

    public static Options adjY(Boolean adjY) {
        return new Options().adjY(adjY);
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=BatchMatMul.class)
    public static class Inputs
    extends RawOpInputs<BatchMatMul<?>> {
        public final Operand<? extends TType> x;
        public final Operand<? extends TType> y;
        public final DataType Ta;
        public final DataType Tb;
        public final DataType Tout;
        public final boolean adjX;
        public final boolean adjY;

        public Inputs(GraphOperation op) {
            super(new BatchMatMul(op), op, Arrays.asList("Ta", "Tb", "Tout", "adj_x", "adj_y"));
            int inputIndex = 0;
            this.x = op.input(inputIndex++);
            this.y = op.input(inputIndex++);
            this.Ta = op.attributes().getAttrType("Ta");
            this.Tb = op.attributes().getAttrType("Tb");
            this.Tout = op.attributes().getAttrType("Tout");
            this.adjX = op.attributes().getAttrBool("adj_x");
            this.adjY = op.attributes().getAttrBool("adj_y");
        }
    }

    public static class Options {
        private Boolean adjX;
        private Boolean adjY;

        private Options() {
        }

        public Options adjX(Boolean adjX) {
            this.adjX = adjX;
            return this;
        }

        public Options adjY(Boolean adjY) {
            this.adjY = adjY;
            return this;
        }
    }
}

