/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.quantization.Dequantize;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxArgs;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxArgsGradient;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVars;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsGradient;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsPerChannel;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsPerChannelGradient;
import org.tensorflow.op.quantization.Quantize;
import org.tensorflow.op.quantization.QuantizeAndDequantize;
import org.tensorflow.op.quantization.QuantizeAndDequantizeV3;
import org.tensorflow.op.quantization.QuantizeAndDequantizeV4;
import org.tensorflow.op.quantization.QuantizeAndDequantizeV4Grad;
import org.tensorflow.op.quantization.QuantizeDownAndShrinkRange;
import org.tensorflow.op.quantization.QuantizedConcat;
import org.tensorflow.op.quantization.RequantizationRange;
import org.tensorflow.op.quantization.Requantize;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class QuantizationOps {
    private final Scope scope;
    private final Ops ops;

    QuantizationOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public Dequantize<TFloat32> dequantize(Operand<? extends TNumber> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, Dequantize.Options[] options) {
        return Dequantize.create(this.scope, input, minRange, maxRange, options);
    }

    public <U extends TNumber> Dequantize<U> dequantize(Operand<? extends TNumber> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, Class<U> dtype, Dequantize.Options ... options) {
        return Dequantize.create(this.scope, input, minRange, maxRange, dtype, options);
    }

    public FakeQuantWithMinMaxArgs fakeQuantWithMinMaxArgs(Operand<TFloat32> inputs, FakeQuantWithMinMaxArgs.Options ... options) {
        return FakeQuantWithMinMaxArgs.create(this.scope, inputs, options);
    }

    public FakeQuantWithMinMaxArgsGradient fakeQuantWithMinMaxArgsGradient(Operand<TFloat32> gradients, Operand<TFloat32> inputs, FakeQuantWithMinMaxArgsGradient.Options ... options) {
        return FakeQuantWithMinMaxArgsGradient.create(this.scope, gradients, inputs, options);
    }

    public FakeQuantWithMinMaxVars fakeQuantWithMinMaxVars(Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, FakeQuantWithMinMaxVars.Options ... options) {
        return FakeQuantWithMinMaxVars.create(this.scope, inputs, min, max, options);
    }

    public FakeQuantWithMinMaxVarsGradient fakeQuantWithMinMaxVarsGradient(Operand<TFloat32> gradients, Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, FakeQuantWithMinMaxVarsGradient.Options ... options) {
        return FakeQuantWithMinMaxVarsGradient.create(this.scope, gradients, inputs, min, max, options);
    }

    public FakeQuantWithMinMaxVarsPerChannel fakeQuantWithMinMaxVarsPerChannel(Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, FakeQuantWithMinMaxVarsPerChannel.Options ... options) {
        return FakeQuantWithMinMaxVarsPerChannel.create(this.scope, inputs, min, max, options);
    }

    public FakeQuantWithMinMaxVarsPerChannelGradient fakeQuantWithMinMaxVarsPerChannelGradient(Operand<TFloat32> gradients, Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, FakeQuantWithMinMaxVarsPerChannelGradient.Options ... options) {
        return FakeQuantWithMinMaxVarsPerChannelGradient.create(this.scope, gradients, inputs, min, max, options);
    }

    public <T extends TNumber> Quantize<T> quantize(Operand<TFloat32> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, Class<T> T, Quantize.Options ... options) {
        return Quantize.create(this.scope, input, minRange, maxRange, T, options);
    }

    public <T extends TNumber> QuantizeAndDequantize<T> quantizeAndDequantize(Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Operand<TInt32> numBits, QuantizeAndDequantize.Options ... options) {
        return QuantizeAndDequantize.create(this.scope, input, inputMin, inputMax, numBits, options);
    }

    public <T extends TNumber> QuantizeAndDequantizeV3<T> quantizeAndDequantizeV3(Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Operand<TInt32> numBits, QuantizeAndDequantizeV3.Options ... options) {
        return QuantizeAndDequantizeV3.create(this.scope, input, inputMin, inputMax, numBits, options);
    }

    public <T extends TNumber> QuantizeAndDequantizeV4<T> quantizeAndDequantizeV4(Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, QuantizeAndDequantizeV4.Options ... options) {
        return QuantizeAndDequantizeV4.create(this.scope, input, inputMin, inputMax, options);
    }

    public <T extends TNumber> QuantizeAndDequantizeV4Grad<T> quantizeAndDequantizeV4Grad(Operand<T> gradients, Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, QuantizeAndDequantizeV4Grad.Options ... options) {
        return QuantizeAndDequantizeV4Grad.create(this.scope, gradients, input, inputMin, inputMax, options);
    }

    public <U extends TNumber> QuantizeDownAndShrinkRange<U> quantizeDownAndShrinkRange(Operand<? extends TNumber> input, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax, Class<U> outType) {
        return QuantizeDownAndShrinkRange.create(this.scope, input, inputMin, inputMax, outType);
    }

    public <T extends TType> QuantizedConcat<T> quantizedConcat(Operand<TInt32> concatDim, Iterable<Operand<T>> values, Iterable<Operand<TFloat32>> inputMins, Iterable<Operand<TFloat32>> inputMaxes) {
        return QuantizedConcat.create(this.scope, concatDim, values, inputMins, inputMaxes);
    }

    public RequantizationRange requantizationRange(Operand<? extends TNumber> input, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax) {
        return RequantizationRange.create(this.scope, input, inputMin, inputMax);
    }

    public <U extends TNumber> Requantize<U> requantize(Operand<? extends TNumber> input, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax, Operand<TFloat32> requestedOutputMin, Operand<TFloat32> requestedOutputMax, Class<U> outType) {
        return Requantize.create(this.scope, input, inputMin, inputMax, requestedOutputMin, requestedOutputMax, outType);
    }

    public final Ops ops() {
        return this.ops;
    }
}

