/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="GeneratorDataset", inputsClass=Inputs.class)
public final class GeneratorDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "GeneratorDataset";
    private Output<? extends TType> handle;

    public GeneratorDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static GeneratorDataset create(Scope scope, Iterable<Operand<?>> initFuncOtherArgs, Iterable<Operand<?>> nextFuncOtherArgs, Iterable<Operand<?>> finalizeFuncOtherArgs, ConcreteFunction initFunc, ConcreteFunction nextFunc, ConcreteFunction finalizeFunc, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(initFuncOtherArgs));
        opBuilder.addInputList(Operands.asOutputs(nextFuncOtherArgs));
        opBuilder.addInputList(Operands.asOutputs(finalizeFuncOtherArgs));
        opBuilder.setAttr("init_func", initFunc);
        opBuilder.setAttr("next_func", nextFunc);
        opBuilder.setAttr("finalize_func", finalizeFunc);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new GeneratorDataset(opBuilder.build());
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=GeneratorDataset.class)
    public static class Inputs
    extends RawOpInputs<GeneratorDataset> {
        public final Iterable<Operand<?>> initFuncOtherArgs;
        public final Iterable<Operand<?>> nextFuncOtherArgs;
        public final Iterable<Operand<?>> finalizeFuncOtherArgs;
        public final DataType[] TinitFuncArgs;
        public final DataType[] TnextFuncArgs;
        public final DataType[] TfinalizeFuncArgs;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new GeneratorDataset(op), op, Arrays.asList("Tinit_func_args", "Tnext_func_args", "Tfinalize_func_args", "output_types", "output_shapes", "metadata"));
            int inputIndex = 0;
            int initFuncOtherArgsLength = op.inputListLength("init_func_other_args");
            this.initFuncOtherArgs = Arrays.asList((Operand[])op.inputList(inputIndex, initFuncOtherArgsLength));
            int nextFuncOtherArgsLength = op.inputListLength("next_func_other_args");
            this.nextFuncOtherArgs = Arrays.asList((Operand[])op.inputList(inputIndex += initFuncOtherArgsLength, nextFuncOtherArgsLength));
            int finalizeFuncOtherArgsLength = op.inputListLength("finalize_func_other_args");
            this.finalizeFuncOtherArgs = Arrays.asList((Operand[])op.inputList(inputIndex += nextFuncOtherArgsLength, finalizeFuncOtherArgsLength));
            inputIndex += finalizeFuncOtherArgsLength;
            this.TinitFuncArgs = op.attributes().getAttrTypeList("Tinit_func_args");
            this.TnextFuncArgs = op.attributes().getAttrTypeList("Tnext_func_args");
            this.TfinalizeFuncArgs = op.attributes().getAttrTypeList("Tfinalize_func_args");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private String metadata;

        private Options() {
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

