/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="DecodeCompressed", inputsClass=Inputs.class)
public final class DecodeCompressed
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "DecodeCompressed";
    private Output<TString> output;

    public DecodeCompressed(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static DecodeCompressed create(Scope scope, Operand<TString> bytes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(bytes.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.compressionType == null) continue;
                opBuilder.setAttr("compression_type", opts.compressionType);
            }
        }
        return new DecodeCompressed(opBuilder.build());
    }

    public static Options compressionType(String compressionType) {
        return new Options().compressionType(compressionType);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=DecodeCompressed.class)
    public static class Inputs
    extends RawOpInputs<DecodeCompressed> {
        public final Operand<TString> bytes;
        public final String compressionType;

        public Inputs(GraphOperation op) {
            super(new DecodeCompressed(op), op, Arrays.asList("compression_type"));
            int inputIndex = 0;
            this.bytes = op.input(inputIndex++);
            this.compressionType = op.attributes().getAttrString("compression_type");
        }
    }

    public static class Options {
        private String compressionType;

        private Options() {
        }

        public Options compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }
    }
}

