/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaPad", inputsClass=Inputs.class)
public final class Pad<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaPad";
    private Output<T> output;

    public Pad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TNumber> Pad<T> create(Scope scope, Operand<T> input, Operand<T> paddingValue, Operand<U> paddingLow, Operand<U> paddingHigh, Operand<U> paddingInterior) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Pad");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(paddingValue.asOutput());
        opBuilder.addInput(paddingLow.asOutput());
        opBuilder.addInput(paddingHigh.asOutput());
        opBuilder.addInput(paddingInterior.asOutput());
        return new Pad<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Pad.class)
    public static class Inputs<T extends TType, U extends TNumber>
    extends RawOpInputs<Pad<T>> {
        public final Operand<T> input;
        public final Operand<T> paddingValue;
        public final Operand<U> paddingLow;
        public final Operand<U> paddingHigh;
        public final Operand<U> paddingInterior;
        public final DataType T;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new Pad(op), op, Arrays.asList("T", "Tindices"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.paddingValue = op.input(inputIndex++);
            this.paddingLow = op.input(inputIndex++);
            this.paddingHigh = op.input(inputIndex++);
            this.paddingInterior = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }
}

