/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="PaddedBatchDatasetV2", inputsClass=Inputs.class)
public final class PaddedBatchDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "PaddedBatchDatasetV2";
    private Output<? extends TType> handle;

    public PaddedBatchDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static PaddedBatchDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> batchSize, Iterable<Operand<TInt64>> paddedShapes, Iterable<Operand<?>> paddingValues, Operand<TBool> dropRemainder, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "PaddedBatchDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(batchSize.asOutput());
        opBuilder.addInputList(Operands.asOutputs(paddedShapes));
        opBuilder.addInputList(Operands.asOutputs(paddingValues));
        opBuilder.addInput(dropRemainder.asOutput());
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.parallelCopy != null) {
                    opBuilder.setAttr("parallel_copy", opts.parallelCopy);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new PaddedBatchDataset(opBuilder.build());
    }

    public static Options parallelCopy(Boolean parallelCopy) {
        return new Options().parallelCopy(parallelCopy);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=PaddedBatchDataset.class)
    public static class Inputs
    extends RawOpInputs<PaddedBatchDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> batchSize;
        public final Iterable<Operand<TInt64>> paddedShapes;
        public final Iterable<Operand<?>> paddingValues;
        public final Operand<TBool> dropRemainder;
        public final boolean parallelCopy;
        public final DataType[] ToutputTypes;
        public final Shape[] outputShapes;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new PaddedBatchDataset(op), op, Arrays.asList("parallel_copy", "Toutput_types", "output_shapes", "metadata"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.batchSize = op.input(inputIndex++);
            int paddedShapesLength = op.inputListLength("padded_shapes");
            this.paddedShapes = Arrays.asList((Operand[])op.inputList(inputIndex, paddedShapesLength));
            int paddingValuesLength = op.inputListLength("padding_values");
            this.paddingValues = Arrays.asList((Operand[])op.inputList(inputIndex += paddedShapesLength, paddingValuesLength));
            inputIndex += paddingValuesLength;
            this.dropRemainder = op.input(inputIndex++);
            this.parallelCopy = op.attributes().getAttrBool("parallel_copy");
            this.ToutputTypes = op.attributes().getAttrTypeList("Toutput_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private Boolean parallelCopy;
        private String metadata;

        private Options() {
        }

        public Options parallelCopy(Boolean parallelCopy) {
            this.parallelCopy = parallelCopy;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

