/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RaggedTensorFromVariant", inputsClass=Inputs.class)
public final class RaggedTensorFromVariant<T extends TNumber, U extends TType>
extends RawOp {
    public static final String OP_NAME = "RaggedTensorFromVariant";
    private List<Output<T>> outputNestedSplits;
    private Output<U> outputDenseValues;

    public RaggedTensorFromVariant(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputNestedSplitsLength = operation.outputListLength("output_nested_splits");
        this.outputNestedSplits = Arrays.asList(operation.outputList(outputIdx, outputNestedSplitsLength));
        outputIdx += outputNestedSplitsLength;
        this.outputDenseValues = operation.output(outputIdx++);
    }

    public static <T extends TNumber, U extends TType> RaggedTensorFromVariant<T, U> create(Scope scope, Operand<? extends TType> encodedRagged, Long inputRaggedRank, Long outputRaggedRank, Class<U> Tvalues, Class<T> Tsplits) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(encodedRagged.asOutput());
        opBuilder.setAttr("input_ragged_rank", inputRaggedRank);
        opBuilder.setAttr("output_ragged_rank", outputRaggedRank);
        opBuilder.setAttr("Tvalues", Operands.toDataType(Tvalues));
        opBuilder.setAttr("Tsplits", Operands.toDataType(Tsplits));
        return new RaggedTensorFromVariant<T, U>(opBuilder.build());
    }

    public static <U extends TType> RaggedTensorFromVariant<TInt64, U> create(Scope scope, Operand<? extends TType> encodedRagged, Long inputRaggedRank, Long outputRaggedRank, Class<U> Tvalues) {
        return RaggedTensorFromVariant.create(scope, encodedRagged, inputRaggedRank, outputRaggedRank, Tvalues, TInt64.class);
    }

    public List<Output<T>> outputNestedSplits() {
        return this.outputNestedSplits;
    }

    public Output<U> outputDenseValues() {
        return this.outputDenseValues;
    }

    @OpInputsMetadata(outputsClass=RaggedTensorFromVariant.class)
    public static class Inputs
    extends RawOpInputs<RaggedTensorFromVariant<?, ?>> {
        public final Operand<? extends TType> encodedRagged;
        public final long inputRaggedRank;
        public final DataType Tvalues;
        public final DataType Tsplits;

        public Inputs(GraphOperation op) {
            super(new RaggedTensorFromVariant(op), op, Arrays.asList("input_ragged_rank", "Tvalues", "Tsplits"));
            int inputIndex = 0;
            this.encodedRagged = op.input(inputIndex++);
            this.inputRaggedRank = op.attributes().getAttrInt("input_ragged_rank");
            this.Tvalues = op.attributes().getAttrType("Tvalues");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
        }
    }
}

