/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;

@OpMetadata(opType="StoreMinibatchStatisticsInFdo", inputsClass=Inputs.class)
public final class StoreMinibatchStatisticsInFdo
extends RawOp {
    public static final String OP_NAME = "StoreMinibatchStatisticsInFdo";

    public StoreMinibatchStatisticsInFdo(Operation operation) {
        super(operation, OP_NAME);
    }

    public static StoreMinibatchStatisticsInFdo create(Scope scope, Operand<TString> programKey, Operand<TInt32> maxIds, Operand<TInt32> maxUniques, Long sampleCount, Long numReplica, Long featureWidth, Long numScPerChip, String tableName, String miniBatchSplits) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(programKey.asOutput());
        opBuilder.addInput(maxIds.asOutput());
        opBuilder.addInput(maxUniques.asOutput());
        opBuilder.setAttr("sample_count", sampleCount);
        opBuilder.setAttr("num_replica", numReplica);
        opBuilder.setAttr("feature_width", featureWidth);
        opBuilder.setAttr("num_sc_per_chip", numScPerChip);
        opBuilder.setAttr("table_name", tableName);
        opBuilder.setAttr("mini_batch_splits", miniBatchSplits);
        return new StoreMinibatchStatisticsInFdo(opBuilder.build());
    }

    @OpInputsMetadata(outputsClass=StoreMinibatchStatisticsInFdo.class)
    public static class Inputs
    extends RawOpInputs<StoreMinibatchStatisticsInFdo> {
        public final Operand<TString> programKey;
        public final Operand<TInt32> maxIds;
        public final Operand<TInt32> maxUniques;
        public final long sampleCount;
        public final long numReplica;
        public final long featureWidth;
        public final long numScPerChip;
        public final String tableName;
        public final String miniBatchSplits;

        public Inputs(GraphOperation op) {
            super(new StoreMinibatchStatisticsInFdo(op), op, Arrays.asList("sample_count", "num_replica", "feature_width", "num_sc_per_chip", "table_name", "mini_batch_splits"));
            int inputIndex = 0;
            this.programKey = op.input(inputIndex++);
            this.maxIds = op.input(inputIndex++);
            this.maxUniques = op.input(inputIndex++);
            this.sampleCount = op.attributes().getAttrInt("sample_count");
            this.numReplica = op.attributes().getAttrInt("num_replica");
            this.featureWidth = op.attributes().getAttrInt("feature_width");
            this.numScPerChip = op.attributes().getAttrInt("num_sc_per_chip");
            this.tableName = op.attributes().getAttrString("table_name");
            this.miniBatchSplits = op.attributes().getAttrString("mini_batch_splits");
        }
    }
}

