/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.math.special.BesselJ0;
import org.tensorflow.op.math.special.BesselJ1;
import org.tensorflow.op.math.special.BesselK0;
import org.tensorflow.op.math.special.BesselK0e;
import org.tensorflow.op.math.special.BesselK1;
import org.tensorflow.op.math.special.BesselK1e;
import org.tensorflow.op.math.special.BesselY0;
import org.tensorflow.op.math.special.BesselY1;
import org.tensorflow.op.math.special.Dawsn;
import org.tensorflow.op.math.special.Expint;
import org.tensorflow.op.math.special.FresnelCos;
import org.tensorflow.op.math.special.FresnelSin;
import org.tensorflow.op.math.special.Spence;
import org.tensorflow.types.family.TNumber;

public final class MathSpecialOps {
    private final Scope scope;
    private final Ops ops;

    MathSpecialOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public <T extends TNumber> BesselJ0<T> besselJ0(Operand<T> x) {
        return BesselJ0.create(this.scope, x);
    }

    public <T extends TNumber> BesselJ1<T> besselJ1(Operand<T> x) {
        return BesselJ1.create(this.scope, x);
    }

    public <T extends TNumber> BesselK0<T> besselK0(Operand<T> x) {
        return BesselK0.create(this.scope, x);
    }

    public <T extends TNumber> BesselK0e<T> besselK0e(Operand<T> x) {
        return BesselK0e.create(this.scope, x);
    }

    public <T extends TNumber> BesselK1<T> besselK1(Operand<T> x) {
        return BesselK1.create(this.scope, x);
    }

    public <T extends TNumber> BesselK1e<T> besselK1e(Operand<T> x) {
        return BesselK1e.create(this.scope, x);
    }

    public <T extends TNumber> BesselY0<T> besselY0(Operand<T> x) {
        return BesselY0.create(this.scope, x);
    }

    public <T extends TNumber> BesselY1<T> besselY1(Operand<T> x) {
        return BesselY1.create(this.scope, x);
    }

    public <T extends TNumber> Dawsn<T> dawsn(Operand<T> x) {
        return Dawsn.create(this.scope, x);
    }

    public <T extends TNumber> Expint<T> expint(Operand<T> x) {
        return Expint.create(this.scope, x);
    }

    public <T extends TNumber> FresnelCos<T> fresnelCos(Operand<T> x) {
        return FresnelCos.create(this.scope, x);
    }

    public <T extends TNumber> FresnelSin<T> fresnelSin(Operand<T> x) {
        return FresnelSin.create(this.scope, x);
    }

    public <T extends TNumber> Spence<T> spence(Operand<T> x) {
        return Spence.create(this.scope, x);
    }

    public final Ops ops() {
        return this.ops;
    }
}

