/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="WindowDataset", inputsClass=Inputs.class)
public final class WindowDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "WindowDataset";
    private Output<? extends TType> handle;

    public WindowDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static WindowDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> sizeOutput, Operand<TInt64> shift, Operand<TInt64> stride, Operand<TBool> dropRemainder, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(sizeOutput.asOutput());
        opBuilder.addInput(shift.asOutput());
        opBuilder.addInput(stride.asOutput());
        opBuilder.addInput(dropRemainder.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new WindowDataset(opBuilder.build());
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=WindowDataset.class)
    public static class Inputs
    extends RawOpInputs<WindowDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> sizeOutput;
        public final Operand<TInt64> shift;
        public final Operand<TInt64> stride;
        public final Operand<TBool> dropRemainder;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new WindowDataset(op), op, Arrays.asList("output_types", "output_shapes", "metadata"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.sizeOutput = op.input(inputIndex++);
            this.shift = op.input(inputIndex++);
            this.stride = op.input(inputIndex++);
            this.dropRemainder = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private String metadata;

        private Options() {
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

