/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.dimension;

import org.tensorflow.ndarray.impl.dimension.AbstractDimension;
import org.tensorflow.ndarray.impl.dimension.Dimension;
import org.tensorflow.ndarray.index.Index;

final class IndexedDimension
extends AbstractDimension {
    private final Index index;
    private final Dimension originalDimension;
    private final long numElements;

    @Override
    public long numElements() {
        return this.numElements;
    }

    @Override
    public long positionOf(long coord) {
        if (coord >= this.numElements()) {
            throw new IndexOutOfBoundsException();
        }
        return this.originalDimension.positionOf(this.index.mapCoordinate(coord, this.originalDimension));
    }

    @Override
    public boolean isSegmented() {
        return true;
    }

    @Override
    public long elementSize() {
        return this.originalDimension.elementSize();
    }

    @Override
    public long physicalSize() {
        return this.originalDimension.physicalSize();
    }

    public String toString() {
        return String.valueOf(this.numElements());
    }

    IndexedDimension(Index index, Dimension originalDimension) {
        this.index = index;
        this.originalDimension = originalDimension;
        this.numElements = index.numElements(originalDimension);
    }
}

