/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="PrintV2", inputsClass=Inputs.class)
public final class Print
extends RawOp {
    public static final String OP_NAME = "PrintV2";

    public Print(Operation operation) {
        super(operation, OP_NAME);
    }

    public static Print create(Scope scope, Operand<TString> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Print");
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.outputStream != null) {
                    opBuilder.setAttr("output_stream", opts.outputStream);
                }
                if (opts.end == null) continue;
                opBuilder.setAttr("end", opts.end);
            }
        }
        return new Print(opBuilder.build());
    }

    public static Options outputStream(String outputStream) {
        return new Options().outputStream(outputStream);
    }

    public static Options end(String end) {
        return new Options().end(end);
    }

    @OpInputsMetadata(outputsClass=Print.class)
    public static class Inputs
    extends RawOpInputs<Print> {
        public final Operand<TString> input;
        public final String outputStream;
        public final String end;

        public Inputs(GraphOperation op) {
            super(new Print(op), op, Arrays.asList("output_stream", "end"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.outputStream = op.attributes().getAttrString("output_stream");
            this.end = op.attributes().getAttrString("end");
        }
    }

    public static class Options {
        private String outputStream;
        private String end;

        private Options() {
        }

        public Options outputStream(String outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public Options end(String end) {
            this.end = end;
            return this;
        }
    }
}

