/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.StatefulWhile;
import org.tensorflow.op.core.StatelessWhile;
import org.tensorflow.types.family.TType;

public interface While
extends Iterable<Operand<TType>> {
    public static While create(Scope scope, Iterable<Operand<?>> input, ConcreteFunction cond, ConcreteFunction body, Options ... options) {
        boolean isStateful = false;
        if (cond.isStateful()) {
            isStateful = true;
        }
        if (body.isStateful()) {
            isStateful = true;
        }
        if (isStateful) {
            return StatefulWhile.create(scope, input, cond, body, options);
        }
        return StatelessWhile.create(scope, input, cond, body, options);
    }

    public static Options outputShapes(List<Shape> outputShapes) {
        return new Options().outputShapes(outputShapes);
    }

    public static Options outputShapes(Shape ... outputShapes) {
        return new Options().outputShapes(outputShapes);
    }

    public static Options parallelIterations(Long parallelIterations) {
        return new Options().parallelIterations(parallelIterations);
    }

    public List<Output<?>> output();

    @Override
    public Iterator<Operand<TType>> iterator();

    public static class Options {
        List<Shape> outputShapes;
        Long parallelIterations;

        private Options() {
        }

        public Options outputShapes(List<Shape> outputShapes) {
            this.outputShapes = outputShapes;
            return this;
        }

        public Options outputShapes(Shape ... outputShapes) {
            this.outputShapes = Arrays.asList(outputShapes);
            return this;
        }

        public Options parallelIterations(Long parallelIterations) {
            this.parallelIterations = parallelIterations;
            return this;
        }
    }
}

