/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="EnqueueTPUEmbeddingSparseBatch", inputsClass=Inputs.class)
public final class EnqueueTPUEmbeddingSparseBatch
extends RawOp {
    public static final String OP_NAME = "EnqueueTPUEmbeddingSparseBatch";

    public EnqueueTPUEmbeddingSparseBatch(Operation operation) {
        super(operation, OP_NAME);
    }

    public static EnqueueTPUEmbeddingSparseBatch create(Scope scope, Iterable<Operand<? extends TNumber>> sampleIndices, Iterable<Operand<? extends TNumber>> embeddingIndices, Iterable<Operand<? extends TNumber>> aggregationWeights, Operand<TString> modeOverride, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(sampleIndices));
        opBuilder.addInputList(Operands.asOutputs(embeddingIndices));
        opBuilder.addInputList(Operands.asOutputs(aggregationWeights));
        opBuilder.addInput(modeOverride.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceOrdinal != null) {
                    opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
                }
                if (opts.combiners == null) continue;
                String[] combinersArray = new String[opts.combiners.size()];
                for (int i = 0; i < combinersArray.length; ++i) {
                    combinersArray[i] = opts.combiners.get(i);
                }
                opBuilder.setAttr("combiners", combinersArray);
            }
        }
        return new EnqueueTPUEmbeddingSparseBatch(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    public static Options combiners(List<String> combiners) {
        return new Options().combiners(combiners);
    }

    public static Options combiners(String ... combiners) {
        return new Options().combiners(combiners);
    }

    @OpInputsMetadata(outputsClass=EnqueueTPUEmbeddingSparseBatch.class)
    public static class Inputs
    extends RawOpInputs<EnqueueTPUEmbeddingSparseBatch> {
        public final Iterable<Operand<? extends TNumber>> sampleIndices;
        public final Iterable<Operand<? extends TNumber>> embeddingIndices;
        public final Iterable<Operand<? extends TNumber>> aggregationWeights;
        public final Operand<TString> modeOverride;
        public final DataType T1;
        public final DataType T2;
        public final DataType T3;
        public final long deviceOrdinal;
        public final String[] combiners;

        public Inputs(GraphOperation op) {
            super(new EnqueueTPUEmbeddingSparseBatch(op), op, Arrays.asList("T1", "T2", "T3", "device_ordinal", "combiners"));
            int inputIndex = 0;
            int sampleIndicesLength = op.inputListLength("sample_indices");
            this.sampleIndices = Arrays.asList((Operand[])op.inputList(inputIndex, sampleIndicesLength));
            int embeddingIndicesLength = op.inputListLength("embedding_indices");
            this.embeddingIndices = Arrays.asList((Operand[])op.inputList(inputIndex += sampleIndicesLength, embeddingIndicesLength));
            int aggregationWeightsLength = op.inputListLength("aggregation_weights");
            this.aggregationWeights = Arrays.asList((Operand[])op.inputList(inputIndex += embeddingIndicesLength, aggregationWeightsLength));
            inputIndex += aggregationWeightsLength;
            this.modeOverride = op.input(inputIndex++);
            this.T1 = op.attributes().getAttrType("T1");
            this.T2 = op.attributes().getAttrType("T2");
            this.T3 = op.attributes().getAttrType("T3");
            this.deviceOrdinal = op.attributes().getAttrInt("device_ordinal");
            this.combiners = op.attributes().getAttrStringList("combiners");
        }
    }

    public static class Options {
        private Long deviceOrdinal;
        private List<String> combiners;

        private Options() {
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }

        public Options combiners(List<String> combiners) {
            this.combiners = combiners;
            return this;
        }

        public Options combiners(String ... combiners) {
            this.combiners = Arrays.asList(combiners);
            return this;
        }
    }
}

