/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="RetrieveTPUEmbeddingProximalYogiParameters", inputsClass=Inputs.class)
public final class RetrieveTPUEmbeddingProximalYogiParameters
extends RawOp {
    public static final String OP_NAME = "RetrieveTPUEmbeddingProximalYogiParameters";
    private Output<TFloat32> parameters;
    private Output<TFloat32> v;
    private Output<TFloat32> m;

    public RetrieveTPUEmbeddingProximalYogiParameters(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.parameters = operation.output(outputIdx++);
        this.v = operation.output(outputIdx++);
        this.m = operation.output(outputIdx++);
    }

    public static RetrieveTPUEmbeddingProximalYogiParameters create(Scope scope, Long numShards, Long shardId, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("num_shards", numShards);
        opBuilder.setAttr("shard_id", shardId);
        if (options != null) {
            for (Options opts : options) {
                if (opts.tableId != null) {
                    opBuilder.setAttr("table_id", opts.tableId);
                }
                if (opts.tableName != null) {
                    opBuilder.setAttr("table_name", opts.tableName);
                }
                if (opts.config == null) continue;
                opBuilder.setAttr("config", opts.config);
            }
        }
        return new RetrieveTPUEmbeddingProximalYogiParameters(opBuilder.build());
    }

    public static Options tableId(Long tableId) {
        return new Options().tableId(tableId);
    }

    public static Options tableName(String tableName) {
        return new Options().tableName(tableName);
    }

    public static Options config(String config) {
        return new Options().config(config);
    }

    public Output<TFloat32> parameters() {
        return this.parameters;
    }

    public Output<TFloat32> v() {
        return this.v;
    }

    public Output<TFloat32> m() {
        return this.m;
    }

    @OpInputsMetadata(outputsClass=RetrieveTPUEmbeddingProximalYogiParameters.class)
    public static class Inputs
    extends RawOpInputs<RetrieveTPUEmbeddingProximalYogiParameters> {
        public final long tableId;
        public final String tableName;
        public final long numShards;
        public final long shardId;
        public final String config;

        public Inputs(GraphOperation op) {
            super(new RetrieveTPUEmbeddingProximalYogiParameters(op), op, Arrays.asList("table_id", "table_name", "num_shards", "shard_id", "config"));
            boolean inputIndex = false;
            this.tableId = op.attributes().getAttrInt("table_id");
            this.tableName = op.attributes().getAttrString("table_name");
            this.numShards = op.attributes().getAttrInt("num_shards");
            this.shardId = op.attributes().getAttrInt("shard_id");
            this.config = op.attributes().getAttrString("config");
        }
    }

    public static class Options {
        private Long tableId;
        private String tableName;
        private String config;

        private Options() {
        }

        public Options tableId(Long tableId) {
            this.tableId = tableId;
            return this;
        }

        public Options tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Options config(String config) {
            this.config = config;
            return this;
        }
    }
}

