/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.lang.reflect.Array;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.SparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.SparseSlice;
import org.tensorflow.ndarray.index.Index;

public class ObjectSparseSlice<T, U extends NdArray<T>>
extends SparseSlice<T, U>
implements NdArray<T> {
    public ObjectSparseSlice(SparseNdArray<T, U> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source, sourcePosition, dimensions);
    }

    @Override
    public U toDense() {
        DataBuffer<T> dataBuffer = DataBuffers.ofObjects(this.getType(), this.shape().size());
        this.copyTo(dataBuffer);
        return (U)NdArrays.wrap(this.shape(), dataBuffer);
    }

    public U setObject(T value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    public U set(NdArray<T> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    public U copyTo(DataBuffer<T> dst) {
        Object[] defaults = (Object[])Array.newInstance(this.getType(), (int)dst.size());
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            Object value = this.getValues().getObject(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return (U)this;
    }

    public U slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public U slice(long position, DimensionalSpace sliceDimensions) {
        return (U)new ObjectSparseSlice<T, U>((SparseNdArray)this.source, position + this.sourcePosition, sliceDimensions);
    }

    @Override
    public U createDefaultArray() {
        return this.source.getDefaultArray();
    }

    public Class<T> getType() {
        return ((SparseNdArray)this.source).getType();
    }
}

