/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MlirPassthroughOp", inputsClass=Inputs.class)
public final class MlirPassthroughOp
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "MlirPassthroughOp";
    private List<Output<?>> outputs;

    public MlirPassthroughOp(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static MlirPassthroughOp create(Scope scope, Iterable<Operand<?>> inputs, String mlirModule, List<Class<? extends TType>> Toutputs) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder.setAttr("mlir_module", mlirModule);
        opBuilder.setAttr("Toutputs", Operands.toDataTypes(Toutputs));
        return new MlirPassthroughOp(opBuilder.build());
    }

    public List<Output<?>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=MlirPassthroughOp.class)
    public static class Inputs
    extends RawOpInputs<MlirPassthroughOp> {
        public final Iterable<Operand<?>> inputs;
        public final String mlirModule;
        public final DataType[] Tinputs;
        public final DataType[] Toutputs;

        public Inputs(GraphOperation op) {
            super(new MlirPassthroughOp(op), op, Arrays.asList("mlir_module", "Tinputs", "Toutputs"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.mlirModule = op.attributes().getAttrString("mlir_module");
            this.Tinputs = op.attributes().getAttrTypeList("Tinputs");
            this.Toutputs = op.attributes().getAttrTypeList("Toutputs");
        }
    }
}

