/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorArrayConcatV3", inputsClass=Inputs.class)
public final class TensorArrayConcat<T extends TType>
extends RawOp {
    public static final String OP_NAME = "TensorArrayConcatV3";
    private Output<T> value;
    private Output<TInt64> lengths;

    public TensorArrayConcat(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
        this.lengths = operation.output(outputIdx++);
    }

    public static <T extends TType> TensorArrayConcat<T> create(Scope scope, Operand<? extends TType> handle, Operand<TFloat32> flowIn, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TensorArrayConcat");
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShapeExcept0 == null) continue;
                opBuilder.setAttr("element_shape_except0", opts.elementShapeExcept0);
            }
        }
        return new TensorArrayConcat<T>(opBuilder.build());
    }

    public static Options elementShapeExcept0(Shape elementShapeExcept0) {
        return new Options().elementShapeExcept0(elementShapeExcept0);
    }

    public Output<T> value() {
        return this.value;
    }

    public Output<TInt64> lengths() {
        return this.lengths;
    }

    @OpInputsMetadata(outputsClass=TensorArrayConcat.class)
    public static class Inputs
    extends RawOpInputs<TensorArrayConcat<?>> {
        public final Operand<? extends TType> handle;
        public final Operand<TFloat32> flowIn;
        public final DataType dtype;
        public final Shape elementShapeExcept0;

        public Inputs(GraphOperation op) {
            super(new TensorArrayConcat(op), op, Arrays.asList("dtype", "element_shape_except0"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.flowIn = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.elementShapeExcept0 = op.attributes().getAttrShape("element_shape_except0");
        }
    }

    public static class Options {
        private Shape elementShapeExcept0;

        private Options() {
        }

        public Options elementShapeExcept0(Shape elementShapeExcept0) {
            this.elementShapeExcept0 = elementShapeExcept0;
            return this;
        }
    }
}

