/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RandomCrop", inputsClass=Inputs.class)
public final class RandomCrop<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RandomCrop";
    private Output<T> output;

    public RandomCrop(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> RandomCrop<T> create(Scope scope, Operand<T> image, Operand<TInt64> sizeOutput, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(image.asOutput());
        opBuilder.addInput(sizeOutput.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new RandomCrop<T>(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RandomCrop.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<RandomCrop<T>> {
        public final Operand<T> image;
        public final Operand<TInt64> sizeOutput;
        public final DataType T;
        public final long seed;
        public final long seed2;

        public Inputs(GraphOperation op) {
            super(new RandomCrop(op), op, Arrays.asList("T", "seed", "seed2"));
            int inputIndex = 0;
            this.image = op.input(inputIndex++);
            this.sizeOutput = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
        }
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        private Options() {
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }
    }
}

