/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UniformRequantize", inputsClass=Inputs.class)
public final class UniformRequantize<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "UniformRequantize";
    private Output<U> output;

    public UniformRequantize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber> UniformRequantize<U> create(Scope scope, Operand<? extends TNumber> input, Operand<TFloat32> inputScales, Operand<TInt32> inputZeroPoints, Operand<TFloat32> outputScales, Operand<TInt32> outputZeroPoints, Class<U> Tout, Long inputQuantizationMinVal, Long inputQuantizationMaxVal, Long outputQuantizationMinVal, Long outputQuantizationMaxVal, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputScales.asOutput());
        opBuilder.addInput(inputZeroPoints.asOutput());
        opBuilder.addInput(outputScales.asOutput());
        opBuilder.addInput(outputZeroPoints.asOutput());
        opBuilder.setAttr("Tout", Operands.toDataType(Tout));
        opBuilder.setAttr("input_quantization_min_val", inputQuantizationMinVal);
        opBuilder.setAttr("input_quantization_max_val", inputQuantizationMaxVal);
        opBuilder.setAttr("output_quantization_min_val", outputQuantizationMinVal);
        opBuilder.setAttr("output_quantization_max_val", outputQuantizationMaxVal);
        if (options != null) {
            for (Options opts : options) {
                if (opts.inputQuantizationAxis != null) {
                    opBuilder.setAttr("input_quantization_axis", opts.inputQuantizationAxis);
                }
                if (opts.outputQuantizationAxis == null) continue;
                opBuilder.setAttr("output_quantization_axis", opts.outputQuantizationAxis);
            }
        }
        return new UniformRequantize<U>(opBuilder.build());
    }

    public static Options inputQuantizationAxis(Long inputQuantizationAxis) {
        return new Options().inputQuantizationAxis(inputQuantizationAxis);
    }

    public static Options outputQuantizationAxis(Long outputQuantizationAxis) {
        return new Options().outputQuantizationAxis(outputQuantizationAxis);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UniformRequantize.class)
    public static class Inputs
    extends RawOpInputs<UniformRequantize<?>> {
        public final Operand<? extends TNumber> input;
        public final Operand<TFloat32> inputScales;
        public final Operand<TInt32> inputZeroPoints;
        public final Operand<TFloat32> outputScales;
        public final Operand<TInt32> outputZeroPoints;
        public final DataType Tin;
        public final DataType Tout;
        public final long inputQuantizationAxis;
        public final long inputQuantizationMinVal;
        public final long inputQuantizationMaxVal;
        public final long outputQuantizationAxis;
        public final long outputQuantizationMinVal;
        public final long outputQuantizationMaxVal;

        public Inputs(GraphOperation op) {
            super(new UniformRequantize(op), op, Arrays.asList("Tin", "Tout", "input_quantization_axis", "input_quantization_min_val", "input_quantization_max_val", "output_quantization_axis", "output_quantization_min_val", "output_quantization_max_val"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.inputScales = op.input(inputIndex++);
            this.inputZeroPoints = op.input(inputIndex++);
            this.outputScales = op.input(inputIndex++);
            this.outputZeroPoints = op.input(inputIndex++);
            this.Tin = op.attributes().getAttrType("Tin");
            this.Tout = op.attributes().getAttrType("Tout");
            this.inputQuantizationAxis = op.attributes().getAttrInt("input_quantization_axis");
            this.inputQuantizationMinVal = op.attributes().getAttrInt("input_quantization_min_val");
            this.inputQuantizationMaxVal = op.attributes().getAttrInt("input_quantization_max_val");
            this.outputQuantizationAxis = op.attributes().getAttrInt("output_quantization_axis");
            this.outputQuantizationMinVal = op.attributes().getAttrInt("output_quantization_min_val");
            this.outputQuantizationMaxVal = op.attributes().getAttrInt("output_quantization_max_val");
        }
    }

    public static class Options {
        private Long inputQuantizationAxis;
        private Long outputQuantizationAxis;

        private Options() {
        }

        public Options inputQuantizationAxis(Long inputQuantizationAxis) {
            this.inputQuantizationAxis = inputQuantizationAxis;
            return this;
        }

        public Options outputQuantizationAxis(Long outputQuantizationAxis) {
            this.outputQuantizationAxis = outputQuantizationAxis;
            return this;
        }
    }
}

