/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.nio;

import java.nio.DoubleBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.nio.AbstractNioDataBuffer;

final class DoubleNioDataBuffer
extends AbstractNioDataBuffer<Double>
implements DoubleDataBuffer {
    private DoubleBuffer buf;

    @Override
    public double getDouble(long index) {
        return this.buf.get((int)index);
    }

    @Override
    public DoubleDataBuffer setDouble(double value, long index) {
        this.buf.put((int)index, value);
        return this;
    }

    @Override
    public DoubleDataBuffer read(double[] dst, int offset, int length) {
        this.buf.duplicate().get(dst, offset, length);
        return this;
    }

    @Override
    public DoubleDataBuffer write(double[] src, int offset, int length) {
        this.buf.duplicate().put(src, offset, length);
        return this;
    }

    @Override
    public DoubleDataBuffer copyTo(final DataBuffer<Double> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<DoubleDataBuffer>(){

            @Override
            public DoubleDataBuffer visit(DoubleBuffer buffer) {
                buffer.duplicate().put(DoubleNioDataBuffer.this.buf.duplicate().limit((int)size));
                return DoubleNioDataBuffer.this;
            }

            @Override
            public DoubleDataBuffer fallback() {
                if (dst instanceof DoubleDataBuffer) {
                    DoubleDataBuffer doubleDst = (DoubleDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        doubleDst.setDouble(DoubleNioDataBuffer.this.getDouble(idx), idx);
                    }
                    return DoubleNioDataBuffer.this;
                }
                return (DoubleDataBuffer)DoubleNioDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public DoubleDataBuffer offset(long index) {
        Validator.offsetArgs(this, index);
        return new DoubleNioDataBuffer(this.buf.duplicate().position((int)index).slice());
    }

    @Override
    public DoubleDataBuffer narrow(long size) {
        Validator.narrowArgs(this, size);
        return new DoubleNioDataBuffer(this.buf.duplicate().limit((int)size).slice());
    }

    @Override
    public DoubleDataBuffer slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        DoubleBuffer sliceBuf = this.buf.duplicate();
        sliceBuf.position((int)index);
        sliceBuf.limit((int)index + (int)size);
        return new DoubleNioDataBuffer(sliceBuf.slice());
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.buf);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleDataBuffer)) {
            return super.equals(obj);
        }
        final DoubleDataBuffer other = (DoubleDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(DoubleBuffer buffer) {
                return DoubleNioDataBuffer.this.buf.equals(buffer);
            }

            @Override
            public Boolean fallback() {
                int idx = 0;
                while ((long)idx < DoubleNioDataBuffer.this.size()) {
                    if (other.getDouble(idx) != DoubleNioDataBuffer.this.getDouble(idx)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        });
    }

    @Override
    DoubleBuffer buf() {
        return this.buf;
    }

    DoubleNioDataBuffer(DoubleBuffer buf) {
        this.buf = buf;
    }
}

