/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ParseSingleSequenceExample", inputsClass=Inputs.class)
public final class ParseSingleSequenceExample
extends RawOp {
    public static final String OP_NAME = "ParseSingleSequenceExample";
    private List<Output<TInt64>> contextSparseIndices;
    private List<Output<?>> contextSparseValues;
    private List<Output<TInt64>> contextSparseShapes;
    private List<Output<?>> contextDenseValues;
    private List<Output<TInt64>> featureListSparseIndices;
    private List<Output<?>> featureListSparseValues;
    private List<Output<TInt64>> featureListSparseShapes;
    private List<Output<?>> featureListDenseValues;

    public ParseSingleSequenceExample(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int contextSparseIndicesLength = operation.outputListLength("context_sparse_indices");
        this.contextSparseIndices = Arrays.asList(operation.outputList(outputIdx, contextSparseIndicesLength));
        int contextSparseValuesLength = operation.outputListLength("context_sparse_values");
        this.contextSparseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseIndicesLength, contextSparseValuesLength));
        int contextSparseShapesLength = operation.outputListLength("context_sparse_shapes");
        this.contextSparseShapes = Arrays.asList(operation.outputList(outputIdx += contextSparseValuesLength, contextSparseShapesLength));
        int contextDenseValuesLength = operation.outputListLength("context_dense_values");
        this.contextDenseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseShapesLength, contextDenseValuesLength));
        int featureListSparseIndicesLength = operation.outputListLength("feature_list_sparse_indices");
        this.featureListSparseIndices = Arrays.asList(operation.outputList(outputIdx += contextDenseValuesLength, featureListSparseIndicesLength));
        int featureListSparseValuesLength = operation.outputListLength("feature_list_sparse_values");
        this.featureListSparseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseIndicesLength, featureListSparseValuesLength));
        int featureListSparseShapesLength = operation.outputListLength("feature_list_sparse_shapes");
        this.featureListSparseShapes = Arrays.asList(operation.outputList(outputIdx += featureListSparseValuesLength, featureListSparseShapesLength));
        int featureListDenseValuesLength = operation.outputListLength("feature_list_dense_values");
        this.featureListDenseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseShapesLength, featureListDenseValuesLength));
        outputIdx += featureListDenseValuesLength;
    }

    public static ParseSingleSequenceExample create(Scope scope, Operand<TString> serialized, Operand<TString> featureListDenseMissingAssumedEmpty, Iterable<Operand<TString>> contextSparseKeys, Iterable<Operand<TString>> contextDenseKeys, Iterable<Operand<TString>> featureListSparseKeys, Iterable<Operand<TString>> featureListDenseKeys, Iterable<Operand<?>> contextDenseDefaults, Operand<TString> debugName, List<Class<? extends TType>> contextSparseTypes, List<Class<? extends TType>> featureListDenseTypes, List<Class<? extends TType>> featureListSparseTypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInput(featureListDenseMissingAssumedEmpty.asOutput());
        opBuilder.addInputList(Operands.asOutputs(contextSparseKeys));
        opBuilder.addInputList(Operands.asOutputs(contextDenseKeys));
        opBuilder.addInputList(Operands.asOutputs(featureListSparseKeys));
        opBuilder.addInputList(Operands.asOutputs(featureListDenseKeys));
        opBuilder.addInputList(Operands.asOutputs(contextDenseDefaults));
        opBuilder.addInput(debugName.asOutput());
        opBuilder.setAttr("context_sparse_types", Operands.toDataTypes(contextSparseTypes));
        opBuilder.setAttr("feature_list_dense_types", Operands.toDataTypes(featureListDenseTypes));
        opBuilder.setAttr("feature_list_sparse_types", Operands.toDataTypes(featureListSparseTypes));
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.NcontextSparse != null) {
                    opBuilder.setAttr("Ncontext_sparse", opts.NcontextSparse);
                }
                if (opts.NcontextDense != null) {
                    opBuilder.setAttr("Ncontext_dense", opts.NcontextDense);
                }
                if (opts.NfeatureListSparse != null) {
                    opBuilder.setAttr("Nfeature_list_sparse", opts.NfeatureListSparse);
                }
                if (opts.NfeatureListDense != null) {
                    opBuilder.setAttr("Nfeature_list_dense", opts.NfeatureListDense);
                }
                if (opts.contextDenseShapes != null) {
                    Shape[] contextDenseShapesArray = new Shape[opts.contextDenseShapes.size()];
                    for (i = 0; i < contextDenseShapesArray.length; ++i) {
                        contextDenseShapesArray[i] = opts.contextDenseShapes.get(i);
                    }
                    opBuilder.setAttr("context_dense_shapes", contextDenseShapesArray);
                }
                if (opts.featureListDenseShapes == null) continue;
                Shape[] featureListDenseShapesArray = new Shape[opts.featureListDenseShapes.size()];
                for (i = 0; i < featureListDenseShapesArray.length; ++i) {
                    featureListDenseShapesArray[i] = opts.featureListDenseShapes.get(i);
                }
                opBuilder.setAttr("feature_list_dense_shapes", featureListDenseShapesArray);
            }
        }
        return new ParseSingleSequenceExample(opBuilder.build());
    }

    public static Options NcontextSparse(Long NcontextSparse) {
        return new Options().NcontextSparse(NcontextSparse);
    }

    public static Options NcontextDense(Long NcontextDense) {
        return new Options().NcontextDense(NcontextDense);
    }

    public static Options NfeatureListSparse(Long NfeatureListSparse) {
        return new Options().NfeatureListSparse(NfeatureListSparse);
    }

    public static Options NfeatureListDense(Long NfeatureListDense) {
        return new Options().NfeatureListDense(NfeatureListDense);
    }

    public static Options contextDenseShapes(List<Shape> contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options contextDenseShapes(Shape ... contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public static Options featureListDenseShapes(Shape ... featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public List<Output<TInt64>> contextSparseIndices() {
        return this.contextSparseIndices;
    }

    public List<Output<?>> contextSparseValues() {
        return this.contextSparseValues;
    }

    public List<Output<TInt64>> contextSparseShapes() {
        return this.contextSparseShapes;
    }

    public List<Output<?>> contextDenseValues() {
        return this.contextDenseValues;
    }

    public List<Output<TInt64>> featureListSparseIndices() {
        return this.featureListSparseIndices;
    }

    public List<Output<?>> featureListSparseValues() {
        return this.featureListSparseValues;
    }

    public List<Output<TInt64>> featureListSparseShapes() {
        return this.featureListSparseShapes;
    }

    public List<Output<?>> featureListDenseValues() {
        return this.featureListDenseValues;
    }

    @OpInputsMetadata(outputsClass=ParseSingleSequenceExample.class)
    public static class Inputs
    extends RawOpInputs<ParseSingleSequenceExample> {
        public final Operand<TString> serialized;
        public final Operand<TString> featureListDenseMissingAssumedEmpty;
        public final Iterable<Operand<TString>> contextSparseKeys;
        public final Iterable<Operand<TString>> contextDenseKeys;
        public final Iterable<Operand<TString>> featureListSparseKeys;
        public final Iterable<Operand<TString>> featureListDenseKeys;
        public final Iterable<Operand<?>> contextDenseDefaults;
        public final Operand<TString> debugName;
        public final DataType[] contextSparseTypes;
        public final DataType[] TcontextDense;
        public final DataType[] featureListDenseTypes;
        public final Shape[] contextDenseShapes;
        public final DataType[] featureListSparseTypes;
        public final Shape[] featureListDenseShapes;

        public Inputs(GraphOperation op) {
            super(new ParseSingleSequenceExample(op), op, Arrays.asList("context_sparse_types", "Tcontext_dense", "feature_list_dense_types", "context_dense_shapes", "feature_list_sparse_types", "feature_list_dense_shapes"));
            int inputIndex = 0;
            this.serialized = op.input(inputIndex++);
            this.featureListDenseMissingAssumedEmpty = op.input(inputIndex++);
            int contextSparseKeysLength = op.inputListLength("context_sparse_keys");
            this.contextSparseKeys = Arrays.asList((Operand[])op.inputList(inputIndex, contextSparseKeysLength));
            int contextDenseKeysLength = op.inputListLength("context_dense_keys");
            this.contextDenseKeys = Arrays.asList((Operand[])op.inputList(inputIndex += contextSparseKeysLength, contextDenseKeysLength));
            int featureListSparseKeysLength = op.inputListLength("feature_list_sparse_keys");
            this.featureListSparseKeys = Arrays.asList((Operand[])op.inputList(inputIndex += contextDenseKeysLength, featureListSparseKeysLength));
            int featureListDenseKeysLength = op.inputListLength("feature_list_dense_keys");
            this.featureListDenseKeys = Arrays.asList((Operand[])op.inputList(inputIndex += featureListSparseKeysLength, featureListDenseKeysLength));
            int contextDenseDefaultsLength = op.inputListLength("context_dense_defaults");
            this.contextDenseDefaults = Arrays.asList((Operand[])op.inputList(inputIndex += featureListDenseKeysLength, contextDenseDefaultsLength));
            inputIndex += contextDenseDefaultsLength;
            this.debugName = op.input(inputIndex++);
            this.contextSparseTypes = op.attributes().getAttrTypeList("context_sparse_types");
            this.TcontextDense = op.attributes().getAttrTypeList("Tcontext_dense");
            this.featureListDenseTypes = op.attributes().getAttrTypeList("feature_list_dense_types");
            this.contextDenseShapes = op.attributes().getAttrShapeList("context_dense_shapes");
            this.featureListSparseTypes = op.attributes().getAttrTypeList("feature_list_sparse_types");
            this.featureListDenseShapes = op.attributes().getAttrShapeList("feature_list_dense_shapes");
        }
    }

    public static class Options {
        private Long NcontextSparse;
        private Long NcontextDense;
        private Long NfeatureListSparse;
        private Long NfeatureListDense;
        private List<Shape> contextDenseShapes;
        private List<Shape> featureListDenseShapes;

        private Options() {
        }

        public Options NcontextSparse(Long NcontextSparse) {
            this.NcontextSparse = NcontextSparse;
            return this;
        }

        public Options NcontextDense(Long NcontextDense) {
            this.NcontextDense = NcontextDense;
            return this;
        }

        public Options NfeatureListSparse(Long NfeatureListSparse) {
            this.NfeatureListSparse = NfeatureListSparse;
            return this;
        }

        public Options NfeatureListDense(Long NfeatureListDense) {
            this.NfeatureListDense = NfeatureListDense;
            return this;
        }

        public Options contextDenseShapes(List<Shape> contextDenseShapes) {
            this.contextDenseShapes = contextDenseShapes;
            return this;
        }

        public Options contextDenseShapes(Shape ... contextDenseShapes) {
            this.contextDenseShapes = Arrays.asList(contextDenseShapes);
            return this;
        }

        public Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
            this.featureListDenseShapes = featureListDenseShapes;
            return this;
        }

        public Options featureListDenseShapes(Shape ... featureListDenseShapes) {
            this.featureListDenseShapes = Arrays.asList(featureListDenseShapes);
            return this;
        }
    }
}

