/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="LSTMBlockCell", inputsClass=Inputs.class)
public final class LSTMBlockCell<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "LSTMBlockCell";
    private Output<T> i;
    private Output<T> cs;
    private Output<T> f;
    private Output<T> o;
    private Output<T> ci;
    private Output<T> co;
    private Output<T> h;

    public LSTMBlockCell(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.i = operation.output(outputIdx++);
        this.cs = operation.output(outputIdx++);
        this.f = operation.output(outputIdx++);
        this.o = operation.output(outputIdx++);
        this.ci = operation.output(outputIdx++);
        this.co = operation.output(outputIdx++);
        this.h = operation.output(outputIdx++);
    }

    public static <T extends TNumber> LSTMBlockCell<T> create(Scope scope, Operand<T> x, Operand<T> csPrev, Operand<T> hPrev, Operand<T> w, Operand<T> wci, Operand<T> wcf, Operand<T> wco, Operand<T> b, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(csPrev.asOutput());
        opBuilder.addInput(hPrev.asOutput());
        opBuilder.addInput(w.asOutput());
        opBuilder.addInput(wci.asOutput());
        opBuilder.addInput(wcf.asOutput());
        opBuilder.addInput(wco.asOutput());
        opBuilder.addInput(b.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.forgetBias != null) {
                    opBuilder.setAttr("forget_bias", opts.forgetBias.floatValue());
                }
                if (opts.cellClip != null) {
                    opBuilder.setAttr("cell_clip", opts.cellClip.floatValue());
                }
                if (opts.usePeephole == null) continue;
                opBuilder.setAttr("use_peephole", opts.usePeephole);
            }
        }
        return new LSTMBlockCell<T>(opBuilder.build());
    }

    public static Options forgetBias(Float forgetBias) {
        return new Options().forgetBias(forgetBias);
    }

    public static Options cellClip(Float cellClip) {
        return new Options().cellClip(cellClip);
    }

    public static Options usePeephole(Boolean usePeephole) {
        return new Options().usePeephole(usePeephole);
    }

    public Output<T> i() {
        return this.i;
    }

    public Output<T> cs() {
        return this.cs;
    }

    public Output<T> f() {
        return this.f;
    }

    public Output<T> o() {
        return this.o;
    }

    public Output<T> ci() {
        return this.ci;
    }

    public Output<T> co() {
        return this.co;
    }

    public Output<T> h() {
        return this.h;
    }

    @OpInputsMetadata(outputsClass=LSTMBlockCell.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<LSTMBlockCell<T>> {
        public final Operand<T> x;
        public final Operand<T> csPrev;
        public final Operand<T> hPrev;
        public final Operand<T> w;
        public final Operand<T> wci;
        public final Operand<T> wcf;
        public final Operand<T> wco;
        public final Operand<T> b;
        public final float forgetBias;
        public final float cellClip;
        public final boolean usePeephole;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new LSTMBlockCell(op), op, Arrays.asList("forget_bias", "cell_clip", "use_peephole", "T"));
            int inputIndex = 0;
            this.x = op.input(inputIndex++);
            this.csPrev = op.input(inputIndex++);
            this.hPrev = op.input(inputIndex++);
            this.w = op.input(inputIndex++);
            this.wci = op.input(inputIndex++);
            this.wcf = op.input(inputIndex++);
            this.wco = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.forgetBias = op.attributes().getAttrFloat("forget_bias");
            this.cellClip = op.attributes().getAttrFloat("cell_clip");
            this.usePeephole = op.attributes().getAttrBool("use_peephole");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Float forgetBias;
        private Float cellClip;
        private Boolean usePeephole;

        private Options() {
        }

        public Options forgetBias(Float forgetBias) {
            this.forgetBias = forgetBias;
            return this;
        }

        public Options cellClip(Float cellClip) {
            this.cellClip = cellClip;
            return this;
        }

        public Options usePeephole(Boolean usePeephole) {
            this.usePeephole = usePeephole;
            return this;
        }
    }
}

