/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseAccumulatorTakeGradient", inputsClass=Inputs.class)
public final class SparseAccumulatorTakeGradient<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseAccumulatorTakeGradient";
    private Output<TInt64> indices;
    private Output<T> values;
    private Output<TInt64> shape;

    public SparseAccumulatorTakeGradient(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.values = operation.output(outputIdx++);
        this.shape = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseAccumulatorTakeGradient<T> create(Scope scope, Operand<TString> handle, Operand<TInt32> numRequired, Class<T> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(numRequired.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new SparseAccumulatorTakeGradient<T>(opBuilder.build());
    }

    public Output<TInt64> indices() {
        return this.indices;
    }

    public Output<T> values() {
        return this.values;
    }

    public Output<TInt64> shape() {
        return this.shape;
    }

    @OpInputsMetadata(outputsClass=SparseAccumulatorTakeGradient.class)
    public static class Inputs
    extends RawOpInputs<SparseAccumulatorTakeGradient<?>> {
        public final Operand<TString> handle;
        public final Operand<TInt32> numRequired;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new SparseAccumulatorTakeGradient(op), op, Arrays.asList("dtype"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.numRequired = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }
}

